/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.examples.wordcount;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.LongDeserializer;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.StreamsBuilder;
import org.apache.kafka.streams.TestInputTopic;
import org.apache.kafka.streams.TestOutputTopic;
import org.apache.kafka.streams.TopologyTestDriver;
import org.apache.kafka.streams.examples.wordcount.WordCountDemo;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class WordCountDemoTest {
    private TopologyTestDriver testDriver;
    private TestInputTopic<String, String> inputTopic;
    private TestOutputTopic<String, Long> outputTopic;

    @Before
    public void setup() {
        StreamsBuilder builder = new StreamsBuilder();
        WordCountDemo.createWordCountStream((StreamsBuilder)builder);
        this.testDriver = new TopologyTestDriver(builder.build(), WordCountDemo.getStreamsConfig());
        this.inputTopic = this.testDriver.createInputTopic("streams-plaintext-input", (Serializer)new StringSerializer(), (Serializer)new StringSerializer());
        this.outputTopic = this.testDriver.createOutputTopic("streams-wordcount-output", (Deserializer)new StringDeserializer(), (Deserializer)new LongDeserializer());
    }

    @After
    public void tearDown() {
        try {
            this.testDriver.close();
        }
        catch (RuntimeException e) {
            System.out.println("Ignoring exception, test failing in Windows due this exception:" + e.getLocalizedMessage());
        }
    }

    @Test
    public void testOneWord() {
        this.inputTopic.pipeInput((Object)"Hello");
        MatcherAssert.assertThat((Object)this.outputTopic.readKeyValue(), (Matcher)CoreMatchers.equalTo((Object)new KeyValue((Object)"hello", (Object)1L)));
        MatcherAssert.assertThat((Object)this.outputTopic.isEmpty(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testCountListOfWords() {
        List<String> inputValues = Arrays.asList("Apache Kafka Streams Example", "Using Kafka Streams Test Utils", "Reading and Writing Kafka Topic");
        HashMap<String, Long> expectedWordCounts = new HashMap<String, Long>();
        expectedWordCounts.put("apache", 1L);
        expectedWordCounts.put("kafka", 3L);
        expectedWordCounts.put("streams", 2L);
        expectedWordCounts.put("example", 1L);
        expectedWordCounts.put("using", 1L);
        expectedWordCounts.put("test", 1L);
        expectedWordCounts.put("utils", 1L);
        expectedWordCounts.put("reading", 1L);
        expectedWordCounts.put("and", 1L);
        expectedWordCounts.put("writing", 1L);
        expectedWordCounts.put("topic", 1L);
        this.inputTopic.pipeValueList(inputValues);
        Map actualWordCounts = this.outputTopic.readKeyValuesToMap();
        MatcherAssert.assertThat((Object)actualWordCounts, (Matcher)CoreMatchers.equalTo(expectedWordCounts));
    }
}

