/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.examples.wordcount;

import java.util.Arrays;
import java.util.List;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.streams.examples.wordcount.WordCountProcessorDemo;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.api.MockProcessorContext;
import org.apache.kafka.streams.processor.api.ProcessorContext;
import org.apache.kafka.streams.processor.api.Record;
import org.apache.kafka.streams.state.KeyValueBytesStoreSupplier;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.Stores;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class WordCountProcessorTest {
    @Test
    public void test() {
        MockProcessorContext context = new MockProcessorContext();
        KeyValueStore store = (KeyValueStore)Stores.keyValueStoreBuilder((KeyValueBytesStoreSupplier)Stores.inMemoryKeyValueStore((String)"Counts"), (Serde)Serdes.String(), (Serde)Serdes.Integer()).withLoggingDisabled().build();
        store.init(context.getStateStoreContext(), (StateStore)store);
        WordCountProcessorDemo.WordCountProcessor processor = new WordCountProcessorDemo.WordCountProcessor();
        processor.init((ProcessorContext)context);
        processor.process(new Record((Object)"key", (Object)"alpha beta\tgamma\n\talpha", 0L));
        Assertions.assertTrue((boolean)context.forwarded().isEmpty());
        ((MockProcessorContext.CapturedPunctuator)context.scheduledPunctuators().get(0)).getPunctuator().punctuate(0L);
        List<MockProcessorContext.CapturedForward> expected = Arrays.asList(new MockProcessorContext.CapturedForward(new Record((Object)"alpha", (Object)"2", 0L)), new MockProcessorContext.CapturedForward(new Record((Object)"beta", (Object)"1", 0L)), new MockProcessorContext.CapturedForward(new Record((Object)"gamma", (Object)"1", 0L)));
        MatcherAssert.assertThat((Object)context.forwarded(), (Matcher)CoreMatchers.is(expected));
    }
}

