/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.examples.wordcount;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.LongDeserializer;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.StreamsBuilder;
import org.apache.kafka.streams.TestInputTopic;
import org.apache.kafka.streams.TestOutputTopic;
import org.apache.kafka.streams.TopologyTestDriver;
import org.apache.kafka.streams.examples.wordcount.WordCountDemo;
import org.apache.kafka.test.TestUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class WordCountDemoTest {
    private TopologyTestDriver testDriver;
    private TestInputTopic<String, String> inputTopic;
    private TestOutputTopic<String, Long> outputTopic;

    @BeforeEach
    public void setup() throws IOException {
        StreamsBuilder builder = new StreamsBuilder();
        WordCountDemo.createWordCountStream((StreamsBuilder)builder);
        this.testDriver = new TopologyTestDriver(builder.build(), WordCountDemo.getStreamsConfig(null));
        this.inputTopic = this.testDriver.createInputTopic("streams-plaintext-input", (Serializer)new StringSerializer(), (Serializer)new StringSerializer());
        this.outputTopic = this.testDriver.createOutputTopic("streams-wordcount-output", (Deserializer)new StringDeserializer(), (Deserializer)new LongDeserializer());
    }

    @AfterEach
    public void tearDown() {
        this.testDriver.close();
    }

    @Test
    public void testOneWord() {
        this.inputTopic.pipeInput((Object)"Hello");
        MatcherAssert.assertThat((Object)this.outputTopic.readKeyValue(), (Matcher)CoreMatchers.equalTo((Object)new KeyValue((Object)"hello", (Object)1L)));
        MatcherAssert.assertThat((Object)this.outputTopic.isEmpty(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testCountListOfWords() {
        List<String> inputValues = Arrays.asList("Apache   Kafka Streams   Example", "Using  \t\t Kafka   Streams\tTest Utils", "Reading and Writing Kafka Topic");
        HashMap<String, Long> expectedWordCounts = new HashMap<String, Long>();
        expectedWordCounts.put("apache", 1L);
        expectedWordCounts.put("kafka", 3L);
        expectedWordCounts.put("streams", 2L);
        expectedWordCounts.put("example", 1L);
        expectedWordCounts.put("using", 1L);
        expectedWordCounts.put("test", 1L);
        expectedWordCounts.put("utils", 1L);
        expectedWordCounts.put("reading", 1L);
        expectedWordCounts.put("and", 1L);
        expectedWordCounts.put("writing", 1L);
        expectedWordCounts.put("topic", 1L);
        this.inputTopic.pipeValueList(inputValues);
        Map actualWordCounts = this.outputTopic.readKeyValuesToMap();
        MatcherAssert.assertThat((Object)actualWordCounts, (Matcher)CoreMatchers.equalTo(expectedWordCounts));
    }

    @Test
    public void testGetStreamsConfig() throws IOException {
        File tmp = TestUtils.tempFile((String)"bootstrap.servers=localhost:1234");
        try {
            Properties config = WordCountDemo.getStreamsConfig((String[])new String[]{tmp.getPath()});
            MatcherAssert.assertThat((Object)"localhost:1234", (Matcher)CoreMatchers.equalTo((Object)config.getProperty("bootstrap.servers")));
            config = WordCountDemo.getStreamsConfig((String[])new String[]{tmp.getPath(), "extra", "args"});
            MatcherAssert.assertThat((Object)"localhost:1234", (Matcher)CoreMatchers.equalTo((Object)config.getProperty("bootstrap.servers")));
        }
        finally {
            Files.deleteIfExists(tmp.toPath());
        }
    }
}

