/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.examples.wordcount;

import java.util.Iterator;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.examples.wordcount.WordCountTransformerDemo;
import org.apache.kafka.streams.kstream.Transformer;
import org.apache.kafka.streams.processor.MockProcessorContext;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.state.StoreBuilder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class WordCountTransformerTest {
    @Test
    public void test() {
        MockProcessorContext context = new MockProcessorContext();
        WordCountTransformerDemo.MyTransformerSupplier supplier = new WordCountTransformerDemo.MyTransformerSupplier();
        for (StoreBuilder storeBuilder : supplier.stores()) {
            StateStore store = storeBuilder.withLoggingDisabled().build();
            store.init((ProcessorContext)context, store);
            context.register(store, null);
        }
        Transformer transformer = supplier.get();
        transformer.init((ProcessorContext)context);
        transformer.transform((Object)"key", (Object)"alpha beta gamma alpha");
        Assertions.assertTrue((boolean)context.forwarded().isEmpty());
        ((MockProcessorContext.CapturedPunctuator)context.scheduledPunctuators().get(0)).getPunctuator().punctuate(0L);
        Iterator capturedForwards = context.forwarded().iterator();
        Assertions.assertEquals((Object)new KeyValue((Object)"alpha", (Object)"2"), (Object)((MockProcessorContext.CapturedForward)capturedForwards.next()).keyValue());
        Assertions.assertEquals((Object)new KeyValue((Object)"beta", (Object)"1"), (Object)((MockProcessorContext.CapturedForward)capturedForwards.next()).keyValue());
        Assertions.assertEquals((Object)new KeyValue((Object)"gamma", (Object)"1"), (Object)((MockProcessorContext.CapturedForward)capturedForwards.next()).keyValue());
        Assertions.assertFalse((boolean)capturedForwards.hasNext());
    }
}

