/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.examples.wordcount;

import java.util.Iterator;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.examples.wordcount.WordCountProcessorDemo;
import org.apache.kafka.streams.processor.MockProcessorContext;
import org.apache.kafka.streams.processor.Processor;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.state.KeyValueBytesStoreSupplier;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.Stores;
import org.junit.Assert;
import org.junit.Test;

public class WordCountProcessorTest {
    @Test
    public void test() {
        MockProcessorContext context = new MockProcessorContext();
        KeyValueStore store = (KeyValueStore)Stores.keyValueStoreBuilder((KeyValueBytesStoreSupplier)Stores.inMemoryKeyValueStore((String)"Counts"), (Serde)Serdes.String(), (Serde)Serdes.Integer()).withLoggingDisabled().build();
        store.init((ProcessorContext)context, (StateStore)store);
        context.register((StateStore)store, null);
        Processor processor = new WordCountProcessorDemo.MyProcessorSupplier().get();
        processor.init((ProcessorContext)context);
        processor.process((Object)"key", (Object)"alpha beta gamma alpha");
        Assert.assertTrue((boolean)context.forwarded().isEmpty());
        ((MockProcessorContext.CapturedPunctuator)context.scheduledPunctuators().get(0)).getPunctuator().punctuate(0L);
        Iterator capturedForwards = context.forwarded().iterator();
        Assert.assertEquals((Object)new KeyValue((Object)"alpha", (Object)"2"), (Object)((MockProcessorContext.CapturedForward)capturedForwards.next()).keyValue());
        Assert.assertEquals((Object)new KeyValue((Object)"beta", (Object)"1"), (Object)((MockProcessorContext.CapturedForward)capturedForwards.next()).keyValue());
        Assert.assertEquals((Object)new KeyValue((Object)"gamma", (Object)"1"), (Object)((MockProcessorContext.CapturedForward)capturedForwards.next()).keyValue());
        Assert.assertFalse((boolean)capturedForwards.hasNext());
    }
}

