/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.storage.internals.log;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ProducerStateManagerConfig {
    public static final String PRODUCER_ID_EXPIRATION_MS = "producer.id.expiration.ms";
    public static final String TRANSACTION_VERIFICATION_ENABLED = "transaction.partition.verification.enable";
    public static final Set<String> RECONFIGURABLE_CONFIGS = new HashSet<String>();
    private volatile int producerIdExpirationMs;
    private volatile boolean transactionVerificationEnabled;
    private final ConcurrentMap<String, Integer> tenantIdToProducerIdExpirationMs;

    public ProducerStateManagerConfig(int producerIdExpirationMs, boolean transactionVerificationEnabled) {
        this.producerIdExpirationMs = producerIdExpirationMs;
        this.transactionVerificationEnabled = transactionVerificationEnabled;
        this.tenantIdToProducerIdExpirationMs = new ConcurrentHashMap<String, Integer>();
    }

    public void setProducerIdExpirationMs(int producerIdExpirationMs) {
        this.producerIdExpirationMs = producerIdExpirationMs;
    }

    public void setProducerIdExpirationMs(Optional<String> tenantIdOpt, Optional<Integer> producerIdExpirationMsOpt) {
        if (tenantIdOpt.isPresent()) {
            if (producerIdExpirationMsOpt.isPresent()) {
                this.tenantIdToProducerIdExpirationMs.put(tenantIdOpt.get(), producerIdExpirationMsOpt.get());
            } else {
                this.tenantIdToProducerIdExpirationMs.remove(tenantIdOpt.get());
            }
        } else if (producerIdExpirationMsOpt.isPresent()) {
            this.setProducerIdExpirationMs(producerIdExpirationMsOpt.get());
        }
    }

    public void setTransactionVerificationEnabled(boolean transactionVerificationEnabled) {
        this.transactionVerificationEnabled = transactionVerificationEnabled;
    }

    public int producerIdExpirationMs() {
        return this.producerIdExpirationMs;
    }

    public int producerIdExpirationMs(Optional<String> tenantIdOpt) {
        return tenantIdOpt.map(tenantId -> this.tenantIdToProducerIdExpirationMs.getOrDefault(tenantId, this.producerIdExpirationMs)).orElse(this.producerIdExpirationMs);
    }

    public boolean transactionVerificationEnabled() {
        return this.transactionVerificationEnabled;
    }

    static {
        RECONFIGURABLE_CONFIGS.add(PRODUCER_ID_EXPIRATION_MS);
        RECONFIGURABLE_CONFIGS.add(TRANSACTION_VERIFICATION_ENABLED);
    }
}

