/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.storage.checksum;

import io.confluent.kafka.availability.FileChannelWrapper;
import io.confluent.kafka.storage.checksum.Algorithm;
import io.confluent.kafka.storage.checksum.CheckedFileIO;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.apache.kafka.common.utils.Utils;

public class NoChecksumFileIO
extends CheckedFileIO {
    public static final short NO_CHECKSUM_SUPER_BLOCK_LENGTH_DEFAULT = 0;

    NoChecksumFileIO(Algorithm algo, short superBlockLength, Path path, OpenOption ... options) throws IOException {
        super(algo, superBlockLength, path, options);
        log.info("Open successfully for file path: " + path + " " + this);
    }

    @Override
    public boolean validate() throws IOException, InstantiationException, IllegalAccessException {
        return true;
    }

    @Override
    public void read(ByteBuffer dst, long position) throws IOException {
        Utils.readFully((FileChannel)this.fileChannel, (ByteBuffer)dst, (long)position);
    }

    @Override
    public void write(ByteBuffer src) throws IOException {
        if (this.readOnly) {
            throw new IllegalArgumentException("Cannot write as file is read-only");
        }
        Utils.writeFully((FileChannel)this.fileChannel, (ByteBuffer)src);
    }

    @Override
    public void write(ByteBuffer src, long position) throws IOException {
        if (this.readOnly) {
            throw new IllegalArgumentException("Cannot write as file is read-only");
        }
        Utils.writeFully((FileChannel)this.fileChannel, (long)position, (ByteBuffer)src);
    }

    @Override
    public long position() throws IOException {
        return this.fileChannel.position();
    }

    @Override
    public void position(long newPosition) throws IOException {
        this.fileChannel.position(newPosition);
    }

    @Override
    public long size() throws IOException {
        return this.fileChannel.size();
    }

    @Override
    public void truncate(long size) throws IOException {
        if (this.readOnly) {
            throw new IllegalArgumentException("Cannot write as file is read-only");
        }
        FileChannelWrapper.truncate((FileChannel)this.fileChannel, (long)size);
    }

    @Override
    public void flush() throws IOException {
        if (this.readOnly) {
            throw new IllegalArgumentException("Cannot flush as file is read-only");
        }
        FileChannelWrapper.force((FileChannel)this.fileChannel, (boolean)true);
    }

    @Override
    public void close() throws IOException {
        FileChannelWrapper.close((FileChannel)this.fileChannel);
    }

    public String toString() {
        return "CheckedFileIO(version=1, algorithm=" + (Object)((Object)this.algorithm) + ", superBlockLength=" + this.superBlockLength + ", checksumPackage=null)";
    }
}

