/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.storage.internals.log;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.apache.kafka.common.InvalidRecordException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MutableRecordBatch;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.RecordConversionStats;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.utils.BufferSupplier;
import org.apache.kafka.common.utils.CloseableIterator;
import org.apache.kafka.common.utils.PrimitiveRef;
import org.apache.kafka.server.interceptor.RecordInterceptor;
import org.apache.kafka.storage.internals.log.AppendOrigin;
import org.apache.kafka.storage.internals.log.KafkaLogValidator;
import org.apache.kafka.storage.internals.log.LogValidator;

public class V2InPlaceLogValidator
implements KafkaLogValidator {
    private final MemoryRecords records;
    private final TopicPartition topicPartition;
    private final boolean compactedTopic;
    private final TimestampType timestampType;
    private final List<RecordInterceptor> interceptors;
    private final long timestampBeforeMaxMs;
    private final long timestampAfterMaxMs;
    private final int partitionLeaderEpoch;
    private final AppendOrigin origin;
    private PrevalidationResult prevalidationResult;

    public V2InPlaceLogValidator(MemoryRecords records, TopicPartition topicPartition, boolean compactedTopic, TimestampType timestampType, long timestampBeforeMaxMs, long timestampAfterMaxMs, List<RecordInterceptor> interceptors, int partitionLeaderEpoch, AppendOrigin origin) {
        this.records = records;
        this.topicPartition = topicPartition;
        this.compactedTopic = compactedTopic;
        this.timestampType = timestampType;
        this.interceptors = interceptors;
        this.timestampBeforeMaxMs = timestampBeforeMaxMs;
        this.timestampAfterMaxMs = timestampAfterMaxMs;
        this.partitionLeaderEpoch = partitionLeaderEpoch;
        this.origin = origin;
    }

    @Override
    public KafkaLogValidator.ValidationResult validateMessagesAndAssignOffsets(PrimitiveRef.LongRef offsetCounter, long currentTimeMs, LogValidator.MetricsRecorder metricsRecorder, BufferSupplier bufferSupplier) {
        if (this.prevalidationResult == null) {
            this.maybePrevalidate(currentTimeMs, metricsRecorder, bufferSupplier);
        }
        return this.assignOffsets(this.prevalidationResult, offsetCounter, this.partitionLeaderEpoch);
    }

    @Override
    public void maybePrevalidate(long currentTimeMs, LogValidator.MetricsRecorder metricsRecorder, BufferSupplier bufferSupplier) {
        this.prevalidationResult = this.prevalidate(currentTimeMs, metricsRecorder, bufferSupplier);
    }

    private PrevalidationResult prevalidate(long currentTimeMs, LogValidator.MetricsRecorder metricsRecorder, BufferSupplier bufferSupplier) {
        MutableRecordBatch batch = V2InPlaceLogValidator.unwrapBatch(this.records);
        LogValidator.validateBatchV2(this.topicPartition, (RecordBatch)batch, this.origin, metricsRecorder);
        return this.validateRecords(batch, currentTimeMs, metricsRecorder, bufferSupplier);
    }

    private KafkaLogValidator.ValidationResult assignOffsets(PrevalidationResult result, PrimitiveRef.LongRef offsetCounter, int partitionLeaderEpoch) {
        MutableRecordBatch batch = V2InPlaceLogValidator.unwrapBatch(result.validatedRecords);
        int numRecords = batch.countOrNull();
        offsetCounter.value += (long)numRecords;
        batch.setLastOffset(offsetCounter.value - 1L);
        batch.setPartitionLeaderEpoch(partitionLeaderEpoch);
        long offsetOfMaxTimestamp = offsetCounter.value - 1L;
        return new KafkaLogValidator.ValidationResult(result.validatedRecords, batch.maxTimestamp(), offsetOfMaxTimestamp, result.messageSizeMaybeChanged, result.recordConversionStats);
    }

    private static MutableRecordBatch unwrapBatch(MemoryRecords records) {
        Iterator batchIterator = records.batches().iterator();
        if (!batchIterator.hasNext()) {
            throw new InvalidRecordException("Record payload contains no batches at all");
        }
        MutableRecordBatch batch = (MutableRecordBatch)batchIterator.next();
        if (batchIterator.hasNext()) {
            throw new InvalidRecordException("Record payload contains more than one batch");
        }
        return batch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PrevalidationResult validateRecords(MutableRecordBatch batch, long currentTimeMs, LogValidator.MetricsRecorder metricsRecorder, BufferSupplier bufferSupplier) {
        CloseableIterator recordsIterator = batch.compressionType() != CompressionType.NONE && this.interceptors.isEmpty() ? batch.skipKeyValueIterator(bufferSupplier) : batch.streamingIterator(bufferSupplier);
        long maxTimestamp = -1L;
        int uncompressedSizeInBytes = 61;
        try {
            ArrayList<LogValidator.ApiRecordError> recordErrors = new ArrayList<LogValidator.ApiRecordError>(0);
            int recordIndex = 0;
            while (recordsIterator.hasNext()) {
                Record record = (Record)recordsIterator.next();
                Optional<LogValidator.ApiRecordError> recordError = LogValidator.validateRecord((RecordBatch)batch, this.topicPartition, record, recordIndex, currentTimeMs, this.timestampType, this.timestampBeforeMaxMs, this.timestampAfterMaxMs, this.compactedTopic, this.interceptors, metricsRecorder);
                if (recordError.isPresent()) {
                    recordErrors.add(recordError.get());
                } else {
                    uncompressedSizeInBytes += record.sizeInBytes();
                    if (record.timestamp() > maxTimestamp) {
                        maxTimestamp = record.timestamp();
                    }
                }
                ++recordIndex;
            }
            LogValidator.processRecordErrors(recordErrors);
        }
        finally {
            recordsIterator.close();
        }
        if (this.timestampType == TimestampType.LOG_APPEND_TIME) {
            batch.setMaxTimestamp(TimestampType.LOG_APPEND_TIME, currentTimeMs);
        } else {
            batch.setMaxTimestamp(this.timestampType, maxTimestamp);
        }
        RecordConversionStats conversionStats = RecordConversionStats.EMPTY;
        if (batch.compressionType() != CompressionType.NONE) {
            conversionStats = new RecordConversionStats((long)uncompressedSizeInBytes, 0, 0L);
        }
        return new PrevalidationResult(this.records, false, conversionStats);
    }

    public static class PrevalidationResult {
        public final MemoryRecords validatedRecords;
        public final boolean messageSizeMaybeChanged;
        public final RecordConversionStats recordConversionStats;

        public PrevalidationResult(MemoryRecords validatedRecords, boolean messageSizeMaybeChanged, RecordConversionStats recordConversionStats) {
            this.validatedRecords = validatedRecords;
            this.messageSizeMaybeChanged = messageSizeMaybeChanged;
            this.recordConversionStats = recordConversionStats;
        }
    }
}

