/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.storage.concurrent;

import io.confluent.kafka.storage.concurrent.SemiCompletionStage;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class KCompletionStage<T>
implements SemiCompletionStage<T> {
    private final CompletionStage<T> inner;

    private KCompletionStage(CompletionStage<T> inner) {
        this.inner = inner;
    }

    public static <T> KCompletionStage<T> from(CompletionStage<T> inner) {
        return new KCompletionStage<T>(inner);
    }

    public static <U> KCompletionStage<U> completedStage(U value) {
        return KCompletionStage.from(CompletableFuture.completedFuture(value));
    }

    public static <T> KCompletionStage<Void> allOf(List<KCompletionStage<T>> list) {
        return KCompletionStage.from(CompletableFuture.allOf((CompletableFuture[])list.stream().map(KCompletionStage::toCompletableFuture).toArray(CompletableFuture[]::new)));
    }

    public static <T> KCompletionStage<Void> anyOf(List<KCompletionStage<T>> list) {
        return KCompletionStage.from(CompletableFuture.anyOf((CompletableFuture[])list.stream().map(KCompletionStage::toCompletableFuture).toArray(CompletableFuture[]::new)).thenApply((T __) -> null));
    }

    public static <T> KCompletionStage<List<T>> allOfList(List<KCompletionStage<T>> list) {
        return KCompletionStage.allOf(list).thenApply(v -> list.stream().map(KCompletionStage::toCompletableFuture).map(CompletableFuture::join).collect(Collectors.toList()));
    }

    public static <U> KCompletionStage<U> failedStage(Throwable ex) {
        if (ex == null) {
            throw new NullPointerException();
        }
        CompletableFuture future = new CompletableFuture();
        future.completeExceptionally(ex);
        return KCompletionStage.from(future);
    }

    public static <U> KCompletionStage<U> supplyAsync(Supplier<U> supplier, Executor executor) {
        return KCompletionStage.from(CompletableFuture.supplyAsync(supplier, executor));
    }

    public static <U> KCompletionStage<U> onExecutor(Supplier<KCompletionStage<U>> supplier, Executor executor) {
        return KCompletionStage.supplyAsync(supplier, executor).thenComposeAsync(Function.identity(), executor);
    }

    public <U> KCompletionStage<U> thenApply(Function<? super T, ? extends U> fn) {
        return KCompletionStage.from(this.inner.thenApply(fn));
    }

    @Override
    public <U> KCompletionStage<U> thenApplyAsync(Function<? super T, ? extends U> fn, Executor executor) {
        return KCompletionStage.from(this.inner.thenApplyAsync(fn, executor));
    }

    public KCompletionStage<Void> thenAccept(Consumer<? super T> action) {
        return KCompletionStage.from(this.inner.thenAccept(action));
    }

    public KCompletionStage<Void> thenAcceptAsync(Consumer<? super T> action, Executor executor) {
        return KCompletionStage.from(this.inner.thenAcceptAsync(action, executor));
    }

    public <U, V> KCompletionStage<V> thenCombine(KCompletionStage<? extends U> other, BiFunction<? super T, ? super U, ? extends V> fn) {
        return KCompletionStage.from(this.inner.thenCombine(other.inner, fn));
    }

    public <U> KCompletionStage<U> applyToEither(KCompletionStage<? extends T> other, Function<? super T, U> fn) {
        return KCompletionStage.from(this.inner.applyToEither(other.toCompletableFuture(), fn));
    }

    public KCompletionStage<Void> acceptEither(CompletionStage<? extends T> other, Consumer<? super T> action) {
        return KCompletionStage.from(this.inner.acceptEither(other, action));
    }

    public <U> KCompletionStage<U> thenCompose(Function<? super T, ? extends KCompletionStage<U>> fn) {
        return KCompletionStage.from(this.inner.thenCompose((? super T param) -> ((KCompletionStage)fn.apply(param)).toCompletableFuture()));
    }

    @Override
    public <U> KCompletionStage<U> thenComposeAsync(Function<? super T, ? extends SemiCompletionStage<U>> fn, Executor executor) {
        return KCompletionStage.from(this.inner.thenComposeAsync((? super T param) -> ((SemiCompletionStage)fn.apply(param)).toCompletableFuture(), executor));
    }

    public <U> KCompletionStage<U> handle(BiFunction<? super T, Throwable, ? extends U> fn) {
        return KCompletionStage.from(this.inner.handle(fn));
    }

    @Override
    public <U> KCompletionStage<U> handleAsync(BiFunction<? super T, Throwable, ? extends U> fn, Executor executor) {
        return KCompletionStage.from(this.inner.handleAsync(fn, executor));
    }

    public KCompletionStage<T> whenComplete(BiConsumer<? super T, ? super Throwable> action) {
        return KCompletionStage.from(this.inner.whenComplete(action));
    }

    @Override
    public KCompletionStage<T> whenCompleteAsync(BiConsumer<? super T, ? super Throwable> action, Executor executor) {
        return KCompletionStage.from(this.inner.whenCompleteAsync(action, executor));
    }

    public KCompletionStage<T> exceptionally(Function<Throwable, ? extends T> fn) {
        return KCompletionStage.from(this.inner.exceptionally(fn));
    }

    public KCompletionStage<T> exceptionallyAsync(Function<Throwable, ? extends T> fn, Executor executor) {
        return KCompletionStage.from(this.inner.handle((r, ex) -> {
            if (ex == null) {
                return this.inner;
            }
            return this.inner.handleAsync((r1, ex1) -> fn.apply((Throwable)ex1), executor);
        }).thenCompose(Function.identity()));
    }

    public KCompletionStage<T> exceptionallyCompose(Function<Throwable, ? extends KCompletionStage<T>> fn) {
        return KCompletionStage.from(this.inner.handle((r, ex) -> {
            if (ex == null) {
                return this.inner.toCompletableFuture();
            }
            return ((KCompletionStage)fn.apply((Throwable)ex)).toCompletableFuture();
        }).thenCompose(Function.identity()));
    }

    public KCompletionStage<T> finallyComposeAsync(BiFunction<? super T, ? super Throwable, KCompletionStage<Void>> fn, Executor executor) {
        CompletionStage<CompletionStage> asyncInner = this.inner.thenComposeAsync((? super T ret) -> ((KCompletionStage)fn.apply(ret, null)).toCompletableFuture().thenApply((T __) -> ret), executor);
        Function<Throwable, CompletionStage> func = throwable -> ((KCompletionStage)fn.apply((Object)null, (Throwable)throwable)).toCompletableFuture().thenApply((T __) -> {
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new RuntimeException((Throwable)throwable);
        });
        return KCompletionStage.from(asyncInner.handle((r, ex) -> {
            if (ex == null) {
                return asyncInner;
            }
            return asyncInner.handleAsync((r1, ex1) -> (CompletionStage)func.apply((Throwable)ex1), executor).thenCompose(Function.identity());
        }).thenCompose(Function.identity()));
    }

    @Override
    public CompletableFuture<T> toCompletableFuture() {
        return this.inner.toCompletableFuture();
    }

    @Override
    public KCompletionStage<T> bind(Executor executor) {
        return this.handleAsync((value, exception) -> {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            if (exception != null) {
                throw new CompletionException((Throwable)exception);
            }
            return value;
        }, executor);
    }
}

