/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.storage.checksum.tools;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.confluent.kafka.storage.checksum.ChecksumStoreFile;
import io.confluent.kafka.storage.checksum.serdes.Entry;
import io.confluent.kafka.storage.checksum.serdes.Store;
import io.confluent.kafka.storage.utils.E2EChecksumUtils;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.internal.HelpScreenException;

public class DumpChecksumStore {
    private static final String DIR_ARG = "directory";
    private static final String FILE_NAME_ARG = "file";

    public static void main(String[] args) throws Exception {
        Namespace parsedArgs = DumpChecksumStore.parseArgs(DumpChecksumStore.createArgParser(), args);
        if (parsedArgs == null) {
            return;
        }
        String directory = parsedArgs.getString(DIR_ARG);
        String fileName = parsedArgs.getString(FILE_NAME_ARG);
        ChecksumStoreFile readerWriter = new ChecksumStoreFile(directory, fileName);
        ByteBuffer buffer = readerWriter.read();
        String json = DumpChecksumStore.convertToJson(buffer).toPrettyString();
        String outputFilePath = "/tmp/" + fileName + "-" + System.currentTimeMillis() + ".json";
        try (FileWriter fileWriter = new FileWriter(outputFilePath);){
            fileWriter.write(json);
            System.out.println("Checksum store is written to json file : " + outputFilePath);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static Namespace parseArgs(ArgumentParser parser, String[] args) throws ArgumentParserException {
        try {
            return parser.parseArgs(args);
        }
        catch (ArgumentParserException e) {
            parser.handleError(e);
            if (e instanceof HelpScreenException) {
                return null;
            }
            throw e;
        }
    }

    private static ArgumentParser createArgParser() {
        ArgumentParser parser = ArgumentParsers.newArgumentParser((String)DumpChecksumStore.class.getName()).defaultHelp(true).description("Dump checksum store file in human readable form to a json file");
        parser.addArgument(new String[]{"--directory"}).setDefault((Object)"/mnt/data/data0/logs").type(String.class).help("The directory argument");
        parser.addArgument(new String[]{"--file"}).setDefault((Object)"checksum.store").type(String.class).help("The file name argument");
        return parser;
    }

    private static JsonNode convertToJson(ByteBuffer buffer) {
        Store store = Store.getRootAsStore(buffer);
        ObjectMapper objectMapper = new ObjectMapper();
        ObjectNode root = objectMapper.createObjectNode();
        ObjectNode headerNode = objectMapper.createObjectNode();
        headerNode.put("version", store.header().version());
        headerNode.put("algorithm", (short)store.header().algorithm());
        root.set("header", (JsonNode)headerNode);
        ArrayNode entriesArray = objectMapper.createArrayNode();
        for (int i = 0; i < store.entriesLength(); ++i) {
            Entry entry = store.entries(i);
            ObjectNode entryNode = objectMapper.createObjectNode();
            entryNode.put("key", entry.key());
            entryNode.put("checksum", E2EChecksumUtils.convertToBase64(entry.checksum()));
            entryNode.put("size_in_bytes", entry.sizeInBytes());
            entryNode.put("last_modified", DumpChecksumStore.convertTimestampToHumanReadableFormat(entry.lastModifiedMs()));
            entryNode.put("last_modified_ms", entry.lastModifiedMs());
            entryNode.put("entry_checksum", E2EChecksumUtils.convertToBase64(entry.entryChecksum()));
            entriesArray.add((JsonNode)entryNode);
        }
        root.set("entries", (JsonNode)entriesArray);
        return root;
    }

    private static String convertTimestampToHumanReadableFormat(long timestampMs) {
        Instant instant = Instant.ofEpochMilli(timestampMs);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd MMM yyyy, HH:mm:ss", Locale.ENGLISH).withZone(ZoneOffset.UTC);
        return formatter.format(instant);
    }
}

