/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.storage.checksum;

import java.util.Arrays;

public enum E2EChecksumProtectedFileType {
    SEGMENT("segment"),
    OFFSET_INDEX("offset-index"),
    TIMESTAMP_INDEX("timestamp-index"),
    TRANSACTION_INDEX("transaction-index"),
    PRODUCER_STATE("producer-state"),
    EPOCH_STATE("epoch-state"),
    TIER_STATE_SNAPSHOT("tier-state-snapshot"),
    LIFECYCLE_MANAGER_STATE("lifecycle-manager-state"),
    BACKUP_OBJECTS_LIST("bkp-list"),
    HEALTH_CHECK("health"),
    TIER_PARTITION_STATE_METADATA_SNAPSHOT("tier-partition-state-metadata-snapshot"),
    TIER_TOPIC_SNAPSHOT("tier-topic-snapshot"),
    DA_OFFSET_MAP("da-offset-map"),
    KRAFT_SNAPSHOT("kraft-checkpoint");

    private final String suffix;

    private E2EChecksumProtectedFileType(String suffix) {
        this.suffix = suffix;
    }

    public String suffix() {
        return this.suffix;
    }

    public static E2EChecksumProtectedFileType fromSuffix(String suffix) {
        for (E2EChecksumProtectedFileType f : E2EChecksumProtectedFileType.values()) {
            if (!f.suffix.equals(suffix)) continue;
            return f;
        }
        throw new IllegalArgumentException("No enum with value " + suffix + " found");
    }

    public static String[] getSupportedFiles() {
        return new String[]{SEGMENT.suffix(), OFFSET_INDEX.suffix(), TIMESTAMP_INDEX.suffix()};
    }

    public static String[] getAllValues() {
        return (String[])Arrays.stream(E2EChecksumProtectedFileType.values()).map(E2EChecksumProtectedFileType::suffix).toArray(String[]::new);
    }
}

