/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.storage.checksum;

import io.confluent.kafka.storage.checksum.ChecksumAlgorithm;
import io.confluent.kafka.storage.checksum.ChecksumHeader;
import io.confluent.kafka.storage.checksum.ChecksumInfo;
import io.confluent.kafka.storage.checksum.ChecksumStore;
import io.confluent.kafka.storage.checksum.ChecksumStoreReaderWriter;
import io.confluent.kafka.storage.checksum.E2EChecksumMetrics;
import java.nio.ByteBuffer;
import java.util.zip.Checksum;
import org.apache.kafka.common.utils.Checksums;
import org.apache.kafka.common.utils.PureJavaCrc32C;
import org.apache.kafka.common.utils.Time;

public class Crc32cChecksumStore
extends ChecksumStore {
    private static final int VERSION = 1;
    private static final int POLY = -2097792136;
    private static final int INVERSE_POLY = 99383025;
    private static final int GF2_DIM = 32;

    public Crc32cChecksumStore(long storeEntryTTL, Time time, ChecksumStoreReaderWriter storeReaderWriter, E2EChecksumMetrics metrics) {
        super(new ChecksumHeader(1, ChecksumAlgorithm.CRC32C), storeEntryTTL, time, storeReaderWriter, metrics);
    }

    @Override
    public ChecksumAlgorithm algorithm() {
        return ChecksumAlgorithm.CRC32C;
    }

    @Override
    protected ChecksumInfo defaultEntry(boolean shouldPersist) {
        return new ChecksumInfo((Checksum)new PureJavaCrc32C(), 0L, System.currentTimeMillis(), shouldPersist);
    }

    @Override
    protected Checksum convertLongToChecksum(long crcValue) {
        return new PureJavaCrc32C((int)(crcValue ^ 0xFFFFFFFFFFFFFFFFL));
    }

    @Override
    protected Checksum truncate(Checksum checksum, ByteBuffer bytesToTruncate) {
        PureJavaCrc32C checksumForTruncatedBytes = new PureJavaCrc32C(0);
        int truncatedLength = bytesToTruncate.remaining();
        Checksums.update((Checksum)checksumForTruncatedBytes, (ByteBuffer)bytesToTruncate, (int)truncatedLength);
        int crcA0 = (int)(checksum.getValue() ^ checksumForTruncatedBytes.getValue());
        return this.removeZeros(crcA0, truncatedLength);
    }

    private Checksum removeZeros(long crc, int zerosToRemove) {
        long[] even = new long[32];
        long[] odd = new long[32];
        long row = 0x80000000L;
        if (zerosToRemove <= 0) {
            return new PureJavaCrc32C((int)crc);
        }
        odd[0] = 99383025L;
        for (int n = 1; n < 32; ++n) {
            odd[n] = row;
            row >>= 1;
        }
        this.gf2_matrix_square(even, odd);
        this.gf2_matrix_square(odd, even);
        do {
            this.gf2_matrix_square(even, odd);
            if ((zerosToRemove & 1) != 0) {
                crc = this.gf2_matrix_times(even, crc);
            }
            if ((zerosToRemove >>= 1) == 0) break;
            this.gf2_matrix_square(odd, even);
            if ((zerosToRemove & 1) == 0) continue;
            crc = this.gf2_matrix_times(odd, crc);
        } while ((zerosToRemove >>= 1) != 0);
        return new PureJavaCrc32C((int)crc);
    }

    private long gf2_matrix_times(long[] matrix, long vector) {
        long sum = 0L;
        int i = 0;
        while (vector != 0L) {
            if ((vector & 0x80000000L) != 0L) {
                sum ^= matrix[i];
            }
            vector = vector << 1 & 0xFFFFFFFFL;
            ++i;
        }
        return sum;
    }

    private void gf2_matrix_square(long[] square, long[] matrix) {
        for (int n = 0; n < 32; ++n) {
            square[n] = this.gf2_matrix_times(matrix, matrix[n]);
        }
    }
}

