/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.log.remote.storage;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.kafka.server.log.remote.storage.LogSegmentData;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentMetadata;
import org.apache.kafka.server.log.remote.storage.RemoteResourceNotFoundException;
import org.apache.kafka.server.log.remote.storage.RemoteStorageException;
import org.apache.kafka.server.log.remote.storage.RemoteStorageManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InmemoryRemoteStorageManager
implements RemoteStorageManager {
    private static final Logger log = LoggerFactory.getLogger(InmemoryRemoteStorageManager.class);
    private Map<String, byte[]> keyToLogData = new ConcurrentHashMap<String, byte[]>();

    static String generateKeyForSegment(RemoteLogSegmentMetadata remoteLogSegmentMetadata) {
        return remoteLogSegmentMetadata.remoteLogSegmentId().id().toString() + ".segment";
    }

    static String generateKeyForIndex(RemoteLogSegmentMetadata remoteLogSegmentMetadata, RemoteStorageManager.IndexType indexType) {
        return remoteLogSegmentMetadata.remoteLogSegmentId().id().toString() + "." + indexType.toString();
    }

    boolean containsKey(String key) {
        return this.keyToLogData.containsKey(key);
    }

    public void copyLogSegmentData(RemoteLogSegmentMetadata remoteLogSegmentMetadata, LogSegmentData logSegmentData) throws RemoteStorageException {
        log.debug("copying log segment and indexes for : {}", (Object)remoteLogSegmentMetadata);
        Objects.requireNonNull(remoteLogSegmentMetadata, "remoteLogSegmentMetadata can not be null");
        Objects.requireNonNull(logSegmentData, "logSegmentData can not be null");
        if (this.keyToLogData.containsKey(InmemoryRemoteStorageManager.generateKeyForSegment(remoteLogSegmentMetadata))) {
            throw new RemoteStorageException("It already contains the segment for the given id: " + remoteLogSegmentMetadata.remoteLogSegmentId());
        }
        try {
            this.keyToLogData.put(InmemoryRemoteStorageManager.generateKeyForSegment(remoteLogSegmentMetadata), Files.readAllBytes(logSegmentData.logSegment()));
            if (logSegmentData.transactionIndex().isPresent()) {
                this.keyToLogData.put(InmemoryRemoteStorageManager.generateKeyForIndex(remoteLogSegmentMetadata, RemoteStorageManager.IndexType.TRANSACTION), Files.readAllBytes((Path)logSegmentData.transactionIndex().get()));
            }
            this.keyToLogData.put(InmemoryRemoteStorageManager.generateKeyForIndex(remoteLogSegmentMetadata, RemoteStorageManager.IndexType.LEADER_EPOCH), logSegmentData.leaderEpochIndex().array());
            this.keyToLogData.put(InmemoryRemoteStorageManager.generateKeyForIndex(remoteLogSegmentMetadata, RemoteStorageManager.IndexType.PRODUCER_SNAPSHOT), Files.readAllBytes(logSegmentData.producerSnapshotIndex()));
            this.keyToLogData.put(InmemoryRemoteStorageManager.generateKeyForIndex(remoteLogSegmentMetadata, RemoteStorageManager.IndexType.OFFSET), Files.readAllBytes(logSegmentData.offsetIndex()));
            this.keyToLogData.put(InmemoryRemoteStorageManager.generateKeyForIndex(remoteLogSegmentMetadata, RemoteStorageManager.IndexType.TIMESTAMP), Files.readAllBytes(logSegmentData.timeIndex()));
        }
        catch (Exception e) {
            throw new RemoteStorageException((Throwable)e);
        }
        log.debug("copied log segment and indexes for : {} successfully.", (Object)remoteLogSegmentMetadata);
    }

    public InputStream fetchLogSegment(RemoteLogSegmentMetadata remoteLogSegmentMetadata, int startPosition) throws RemoteStorageException {
        log.debug("Received fetch segment request at start position: [{}] for [{}]", (Object)startPosition, (Object)remoteLogSegmentMetadata);
        Objects.requireNonNull(remoteLogSegmentMetadata, "remoteLogSegmentMetadata can not be null");
        return this.fetchLogSegment(remoteLogSegmentMetadata, startPosition, Integer.MAX_VALUE);
    }

    public InputStream fetchLogSegment(RemoteLogSegmentMetadata remoteLogSegmentMetadata, int startPosition, int endPosition) throws RemoteStorageException {
        log.debug("Received fetch segment request at start position: [{}] and end position: [{}] for segment [{}]", new Object[]{startPosition, endPosition, remoteLogSegmentMetadata});
        Objects.requireNonNull(remoteLogSegmentMetadata, "remoteLogSegmentMetadata can not be null");
        if (startPosition < 0 || endPosition < 0) {
            throw new IllegalArgumentException("Given start position or end position must not be negative.");
        }
        if (endPosition < startPosition) {
            throw new IllegalArgumentException("end position must be greater than or equal to start position");
        }
        String key = InmemoryRemoteStorageManager.generateKeyForSegment(remoteLogSegmentMetadata);
        byte[] segment = this.keyToLogData.get(key);
        if (segment == null) {
            throw new RemoteResourceNotFoundException("No remote log segment found with start offset:" + remoteLogSegmentMetadata.startOffset() + " and id: " + remoteLogSegmentMetadata.remoteLogSegmentId());
        }
        if (startPosition >= segment.length) {
            throw new IllegalArgumentException("start position: " + startPosition + " must be less than the length of the segment: " + segment.length);
        }
        int length = Math.min(segment.length - 1, endPosition) - startPosition + 1;
        log.debug("Length of the segment to be sent: [{}], for segment: [{}]", (Object)length, (Object)remoteLogSegmentMetadata);
        return new ByteArrayInputStream(segment, startPosition, length);
    }

    public InputStream fetchIndex(RemoteLogSegmentMetadata remoteLogSegmentMetadata, RemoteStorageManager.IndexType indexType) throws RemoteStorageException {
        log.debug("Received fetch request for index type: [{}], segment [{}]", (Object)indexType, (Object)remoteLogSegmentMetadata);
        Objects.requireNonNull(remoteLogSegmentMetadata, "remoteLogSegmentMetadata can not be null");
        Objects.requireNonNull(indexType, "indexType can not be null");
        String key = InmemoryRemoteStorageManager.generateKeyForIndex(remoteLogSegmentMetadata, indexType);
        byte[] index = this.keyToLogData.get(key);
        if (index == null) {
            throw new RemoteResourceNotFoundException("No remote log segment index found with start offset:" + remoteLogSegmentMetadata.startOffset() + " and id: " + remoteLogSegmentMetadata.remoteLogSegmentId());
        }
        return new ByteArrayInputStream(index);
    }

    public void deleteLogSegmentData(RemoteLogSegmentMetadata remoteLogSegmentMetadata) {
        log.info("Deleting log segment for: [{}]", (Object)remoteLogSegmentMetadata);
        Objects.requireNonNull(remoteLogSegmentMetadata, "remoteLogSegmentMetadata can not be null");
        String segmentKey = InmemoryRemoteStorageManager.generateKeyForSegment(remoteLogSegmentMetadata);
        this.keyToLogData.remove(segmentKey);
        for (RemoteStorageManager.IndexType indexType : RemoteStorageManager.IndexType.values()) {
            String key = InmemoryRemoteStorageManager.generateKeyForIndex(remoteLogSegmentMetadata, indexType);
            this.keyToLogData.remove(key);
        }
        log.info("Deleted log segment successfully for: [{}]", (Object)remoteLogSegmentMetadata);
    }

    public void close() throws IOException {
        this.keyToLogData = Collections.emptyMap();
    }

    public void configure(Map<String, ?> configs) {
    }
}

