/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.log.remote.metadata.storage;

import java.util.Collections;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.log.remote.metadata.storage.serialization.RemoteLogSegmentMetadataTransform;
import org.apache.kafka.server.log.remote.metadata.storage.serialization.RemoteLogSegmentMetadataUpdateTransform;
import org.apache.kafka.server.log.remote.metadata.storage.serialization.RemotePartitionDeleteMetadataTransform;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentId;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentMetadata;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentMetadataUpdate;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentState;
import org.apache.kafka.server.log.remote.storage.RemotePartitionDeleteMetadata;
import org.apache.kafka.server.log.remote.storage.RemotePartitionDeleteState;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RemoteLogMetadataTransformTest {
    private static final TopicIdPartition TP0 = new TopicIdPartition(Uuid.randomUuid(), new TopicPartition("foo", 0));
    private final Time time = new MockTime(1L);

    @Test
    public void testRemoteLogSegmentMetadataTransform() {
        RemoteLogSegmentMetadataTransform metadataTransform = new RemoteLogSegmentMetadataTransform();
        RemoteLogSegmentMetadata metadata = this.createRemoteLogSegmentMetadata();
        ApiMessageAndVersion apiMessageAndVersion = metadataTransform.toApiMessageAndVersion(metadata);
        RemoteLogSegmentMetadata remoteLogSegmentMetadataFromRecord = metadataTransform.fromApiMessageAndVersion(apiMessageAndVersion);
        Assertions.assertEquals((Object)metadata, (Object)remoteLogSegmentMetadataFromRecord);
    }

    @Test
    public void testRemoteLogSegmentMetadataUpdateTransform() {
        RemoteLogSegmentMetadataUpdateTransform metadataUpdateTransform = new RemoteLogSegmentMetadataUpdateTransform();
        RemoteLogSegmentMetadataUpdate metadataUpdate = new RemoteLogSegmentMetadataUpdate(new RemoteLogSegmentId(TP0, Uuid.randomUuid()), this.time.milliseconds(), RemoteLogSegmentState.COPY_SEGMENT_FINISHED, 1);
        ApiMessageAndVersion apiMessageAndVersion = metadataUpdateTransform.toApiMessageAndVersion(metadataUpdate);
        RemoteLogSegmentMetadataUpdate metadataUpdateFromRecord = metadataUpdateTransform.fromApiMessageAndVersion(apiMessageAndVersion);
        Assertions.assertEquals((Object)metadataUpdate, (Object)metadataUpdateFromRecord);
    }

    private RemoteLogSegmentMetadata createRemoteLogSegmentMetadata() {
        RemoteLogSegmentId remoteLogSegmentId = new RemoteLogSegmentId(TP0, Uuid.randomUuid());
        return new RemoteLogSegmentMetadata(remoteLogSegmentId, 0L, 100L, -1L, 1, this.time.milliseconds(), 1024, Collections.singletonMap(0, 0L));
    }

    @Test
    public void testRemoteLogPartitionMetadataTransform() {
        RemotePartitionDeleteMetadataTransform transform = new RemotePartitionDeleteMetadataTransform();
        RemotePartitionDeleteMetadata partitionDeleteMetadata = new RemotePartitionDeleteMetadata(TP0, RemotePartitionDeleteState.DELETE_PARTITION_STARTED, this.time.milliseconds(), 1);
        ApiMessageAndVersion apiMessageAndVersion = transform.toApiMessageAndVersion(partitionDeleteMetadata);
        RemotePartitionDeleteMetadata partitionDeleteMetadataFromRecord = transform.fromApiMessageAndVersion(apiMessageAndVersion);
        Assertions.assertEquals((Object)partitionDeleteMetadata, (Object)partitionDeleteMetadataFromRecord);
    }
}

