/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.storage.internals.log;

import io.confluent.kafka.availability.FilesWrapper;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Optional;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.storage.internals.log.LogFileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnapshotFile {
    private static final Logger log = LoggerFactory.getLogger(SnapshotFile.class);
    public final long offset;
    private volatile File file;
    private volatile Optional<FileChannel> fileChannel = Optional.empty();

    public SnapshotFile(File file) {
        this(file, LogFileUtils.offsetFromFileName(file.getName()));
    }

    public SnapshotFile(File file, long offset) {
        this.file = file;
        this.offset = offset;
    }

    public boolean deleteIfExists() throws IOException {
        this.close();
        boolean deleted = FilesWrapper.deleteIfExists((Path)this.file.toPath());
        if (deleted) {
            log.info("Deleted producer state snapshot {}", (Object)this.file.getAbsolutePath());
        } else {
            log.info("Failed to delete producer state snapshot {} because it does not exist.", (Object)this.file.getAbsolutePath());
        }
        return deleted;
    }

    public void updateParentDir(File parentDir) {
        String name = this.file.getName();
        this.file = new File(parentDir, name);
    }

    public File file() {
        return this.file;
    }

    public void renameTo(String newSuffix) throws IOException {
        File renamed = new File(Utils.replaceSuffix((String)this.file.getPath(), (String)"", (String)newSuffix));
        try {
            Utils.atomicMoveWithFallback((Path)this.file.toPath(), (Path)renamed.toPath());
        }
        finally {
            this.file = renamed;
        }
    }

    public boolean isOpenForWrite() {
        return this.fileChannel.isPresent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void maybeOpenForWrite() throws IOException {
        if (!this.fileChannel.isPresent()) {
            SnapshotFile snapshotFile = this;
            synchronized (snapshotFile) {
                if (!this.fileChannel.isPresent()) {
                    this.fileChannel = Optional.of(FileChannel.open(this.file.toPath(), StandardOpenOption.CREATE, StandardOpenOption.WRITE));
                }
            }
        }
    }

    public synchronized void write(ByteBuffer buffer) throws IOException {
        FileChannel channel = this.fileChannel.orElseThrow(() -> new IllegalStateException("The file handle for producer snapshot file: " + this.file + " is not open for write"));
        channel.write(buffer, 0L);
    }

    public synchronized void flush() throws IOException {
        if (this.fileChannel.isPresent()) {
            this.fileChannel.get().force(true);
        }
    }

    public synchronized void close() throws IOException {
        if (this.fileChannel.isPresent()) {
            this.fileChannel.get().close();
            this.fileChannel = Optional.empty();
        }
    }

    public String toString() {
        return "SnapshotFile(offset=" + this.offset + ", file=" + this.file + ')';
    }
}

