/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.storage.checksum;

import com.google.flatbuffers.FlatBufferBuilder;
import io.confluent.kafka.storage.checksum.ChecksumAlgorithm;
import io.confluent.kafka.storage.checksum.ChecksumHeader;
import io.confluent.kafka.storage.checksum.ChecksumInfo;
import io.confluent.kafka.storage.checksum.serdes.Entry;
import io.confluent.kafka.storage.checksum.serdes.Header;
import io.confluent.kafka.storage.checksum.serdes.Store;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.zip.Checksum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ChecksumStore {
    private static final int STORE_BUFFER_INIT_LENGTH = 0x100000;
    private static final Logger LOG = LoggerFactory.getLogger(ChecksumStore.class);
    protected ChecksumHeader header;
    private Map<String, ChecksumInfo> entries = new ConcurrentHashMap<String, ChecksumInfo>();

    protected ChecksumStore(ChecksumHeader header) {
        this.header = header;
    }

    public abstract ChecksumAlgorithm algorithm();

    protected abstract ChecksumInfo defaultEntry();

    protected abstract Checksum convertLongToChecksum(long var1);

    public abstract boolean update(String var1, ByteBuffer var2);

    public abstract boolean update(String var1, int var2);

    public abstract boolean update(String var1, long var2);

    public void initializeEntry(String key) {
        this.entries.put(key, this.defaultEntry());
    }

    public ChecksumInfo get(String key) {
        return this.entries.get(key);
    }

    protected void put(String key, ChecksumInfo checksumInfo) {
        this.entries.put(key, checksumInfo);
    }

    public ChecksumInfo remove(String key) {
        return this.entries.remove(key);
    }

    public ByteBuffer serialize() {
        FlatBufferBuilder builder = new FlatBufferBuilder(0x100000).forceDefaults(true);
        int headerOffset = Header.createHeader(builder, this.header.version(), this.header.algorithm().value());
        ArrayList<Integer> entryOffsets = new ArrayList<Integer>();
        for (Map.Entry<String, ChecksumInfo> entry : this.entries.entrySet()) {
            String key = entry.getKey();
            ChecksumInfo value = entry.getValue();
            int keyOffset = builder.createString((CharSequence)key);
            int entryOffset = Entry.createEntry(builder, keyOffset, value.checksum().getValue(), value.sizeInBytes(), value.lastModifiedMs(), 0L);
            entryOffsets.add(entryOffset);
        }
        int entryVectorOffset = Store.createEntriesVector(builder, entryOffsets.stream().mapToInt(i -> i).toArray());
        int storeOffset = Store.createStore(builder, headerOffset, entryVectorOffset);
        builder.finish(storeOffset);
        return builder.dataBuffer().slice();
    }

    public synchronized void deserialize(ByteBuffer buffer) {
        long entryCount = 0L;
        Store store = Store.getRootAsStore(buffer);
        Header hdr = store.header();
        ConcurrentHashMap<String, ChecksumInfo> newEntries = new ConcurrentHashMap<String, ChecksumInfo>();
        for (int i = 0; i < store.entriesLength(); ++i) {
            Entry entry = store.entries(i);
            ChecksumInfo info = new ChecksumInfo(this.convertLongToChecksum(entry.checksum()), entry.sizeInBytes(), entry.lastModifiedMs());
            newEntries.put(entry.key(), info);
            ++entryCount;
        }
        this.header = new ChecksumHeader(hdr.version(), ChecksumAlgorithm.fromValue(hdr.algorithm()));
        this.entries = newEntries;
        LOG.info("Deserialization completed and checksum store state restored with {} entries.", (Object)entryCount);
    }
}

