/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.storage.internals.log;

import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.storage.internals.log.CompletedTxn;

public class AbortedTxn {
    static final int VERSION_OFFSET = 0;
    static final int VERSION_SIZE = 2;
    static final int PRODUCER_ID_OFFSET = 2;
    static final int PRODUCER_ID_SIZE = 8;
    static final int FIRST_OFFSET_OFFSET = 10;
    static final int FIRST_OFFSET_SIZE = 8;
    static final int LAST_OFFSET_OFFSET = 18;
    static final int LAST_OFFSET_SIZE = 8;
    static final int LAST_STABLE_OFFSET_OFFSET = 26;
    static final int LAST_STABLE_OFFSET_SIZE = 8;
    public static final int TOTAL_SIZE = 34;
    public static final short CURRENT_VERSION = 0;
    final ByteBuffer buffer;

    public AbortedTxn(ByteBuffer buffer) {
        Objects.requireNonNull(buffer);
        this.buffer = buffer;
    }

    public AbortedTxn(CompletedTxn completedTxn, long lastStableOffset) {
        this(completedTxn.producerId, completedTxn.firstOffset, completedTxn.lastOffset, lastStableOffset);
    }

    public AbortedTxn(long producerId, long firstOffset, long lastOffset, long lastStableOffset) {
        this(AbortedTxn.toByteBuffer(producerId, firstOffset, lastOffset, lastStableOffset));
    }

    private static ByteBuffer toByteBuffer(long producerId, long firstOffset, long lastOffset, long lastStableOffset) {
        ByteBuffer buffer = ByteBuffer.allocate(34);
        buffer.putShort((short)0);
        buffer.putLong(producerId);
        buffer.putLong(firstOffset);
        buffer.putLong(lastOffset);
        buffer.putLong(lastStableOffset);
        buffer.flip();
        return buffer;
    }

    public short version() {
        return this.buffer.get(0);
    }

    public long producerId() {
        return this.buffer.getLong(2);
    }

    public long firstOffset() {
        return this.buffer.getLong(10);
    }

    public long lastOffset() {
        return this.buffer.getLong(18);
    }

    public long lastStableOffset() {
        return this.buffer.getLong(26);
    }

    public FetchResponseData.AbortedTransaction asAbortedTransaction() {
        return new FetchResponseData.AbortedTransaction().setProducerId(this.producerId()).setFirstOffset(this.firstOffset());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbortedTxn that = (AbortedTxn)o;
        return this.buffer.equals(that.buffer);
    }

    public int hashCode() {
        return this.buffer.hashCode();
    }

    public String toString() {
        return "AbortedTxn(version=" + this.version() + ", producerId=" + this.producerId() + ", firstOffset=" + this.firstOffset() + ", lastOffset=" + this.lastOffset() + ", lastStableOffset=" + this.lastStableOffset() + ")";
    }

    public static Optional<ByteBuffer> serialize(List<AbortedTxn> abortedTxns) {
        if (abortedTxns.isEmpty()) {
            return Optional.empty();
        }
        ByteBuffer buf = ByteBuffer.allocate(abortedTxns.size() * 34);
        for (AbortedTxn abortedTxn : abortedTxns) {
            buf.put(abortedTxn.buffer.duplicate());
        }
        buf.flip();
        return Optional.of(buf);
    }
}

