/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.log.remote.metadata.storage;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.server.log.remote.metadata.storage.RemoteLogMetadataSnapshotFile;
import org.apache.kafka.server.log.remote.metadata.storage.RemoteLogSegmentMetadataSnapshot;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentState;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RemoteLogMetadataSnapshotFileTest {
    @Test
    public void testEmptyCommittedLogMetadataFile() throws Exception {
        File metadataStoreDir = TestUtils.tempDirectory((String)"_rlmm_committed");
        RemoteLogMetadataSnapshotFile snapshotFile = new RemoteLogMetadataSnapshotFile(metadataStoreDir.toPath());
        Assertions.assertFalse((boolean)snapshotFile.read().isPresent());
    }

    @Test
    public void testEmptySnapshotWithCommittedLogMetadataFile() throws Exception {
        File metadataStoreDir = TestUtils.tempDirectory((String)"_rlmm_committed");
        RemoteLogMetadataSnapshotFile snapshotFile = new RemoteLogMetadataSnapshotFile(metadataStoreDir.toPath());
        snapshotFile.write(new RemoteLogMetadataSnapshotFile.Snapshot(0, 0L, Collections.emptyList()));
        Assertions.assertTrue((boolean)snapshotFile.read().isPresent());
        Assertions.assertTrue((boolean)((RemoteLogMetadataSnapshotFile.Snapshot)snapshotFile.read().get()).remoteLogSegmentMetadataSnapshots().isEmpty());
    }

    @Test
    public void testWriteReadCommittedLogMetadataFile() throws Exception {
        File metadataStoreDir = TestUtils.tempDirectory((String)"_rlmm_committed");
        RemoteLogMetadataSnapshotFile snapshotFile = new RemoteLogMetadataSnapshotFile(metadataStoreDir.toPath());
        ArrayList<RemoteLogSegmentMetadataSnapshot> remoteLogSegmentMetadatas = new ArrayList<RemoteLogSegmentMetadataSnapshot>();
        long startOffset = 0L;
        for (int i = 0; i < 100; ++i) {
            long endOffset = startOffset + 100L;
            remoteLogSegmentMetadatas.add(new RemoteLogSegmentMetadataSnapshot(Uuid.randomUuid(), startOffset, endOffset, System.currentTimeMillis(), 1, 100L, 1024, RemoteLogSegmentState.COPY_SEGMENT_FINISHED, Collections.singletonMap(i, startOffset)));
            startOffset = endOffset + 1L;
        }
        RemoteLogMetadataSnapshotFile.Snapshot snapshot = new RemoteLogMetadataSnapshotFile.Snapshot(0, 120L, remoteLogSegmentMetadatas);
        snapshotFile.write(snapshot);
        Optional maybeReadSnapshot = snapshotFile.read();
        Assertions.assertTrue((boolean)maybeReadSnapshot.isPresent());
        Assertions.assertEquals((Object)snapshot, maybeReadSnapshot.get());
        Assertions.assertEquals(new HashSet(snapshot.remoteLogSegmentMetadataSnapshots()), new HashSet(((RemoteLogMetadataSnapshotFile.Snapshot)maybeReadSnapshot.get()).remoteLogSegmentMetadataSnapshots()));
    }
}

