/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tiered.storage.specs;

import java.util.Objects;
import org.apache.kafka.common.TopicPartition;

public final class RemoteFetchSpec {
    private final int sourceBrokerId;
    private final TopicPartition topicPartition;
    private final int count;

    public RemoteFetchSpec(int sourceBrokerId, TopicPartition topicPartition, int count) {
        this.sourceBrokerId = sourceBrokerId;
        this.topicPartition = topicPartition;
        this.count = count;
    }

    public int getSourceBrokerId() {
        return this.sourceBrokerId;
    }

    public TopicPartition getTopicPartition() {
        return this.topicPartition;
    }

    public int getCount() {
        return this.count;
    }

    public String toString() {
        return String.format("RemoteFetch[source-broker-id=%d topic-partition=%s count=%d]", this.sourceBrokerId, this.topicPartition, this.count);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RemoteFetchSpec that = (RemoteFetchSpec)o;
        return this.sourceBrokerId == that.sourceBrokerId && this.count == that.count && Objects.equals(this.topicPartition, that.topicPartition);
    }

    public int hashCode() {
        return Objects.hash(this.sourceBrokerId, this.topicPartition, this.count);
    }
}

