/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tiered.storage.specs;

import java.util.List;
import java.util.Objects;
import org.apache.kafka.clients.producer.ProducerRecord;

public final class ProducableSpec {
    private final List<ProducerRecord<String, String>> records;
    private Integer batchSize;
    private Long earliestLocalLogOffset;

    public ProducableSpec(List<ProducerRecord<String, String>> records, Integer batchSize, Long earliestLocalLogOffset) {
        this.records = records;
        this.batchSize = batchSize;
        this.earliestLocalLogOffset = earliestLocalLogOffset;
    }

    public List<ProducerRecord<String, String>> getRecords() {
        return this.records;
    }

    public Integer getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(Integer batchSize) {
        this.batchSize = batchSize;
    }

    public Long getEarliestLocalLogOffset() {
        return this.earliestLocalLogOffset;
    }

    public void setEarliestLocalLogOffset(Long earliestLocalLogOffset) {
        this.earliestLocalLogOffset = earliestLocalLogOffset;
    }

    public String toString() {
        return "ProducableSpec{records=" + this.records + ", batchSize=" + this.batchSize + ", earliestLocalLogOffset=" + this.earliestLocalLogOffset + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProducableSpec that = (ProducableSpec)o;
        return Objects.equals(this.records, that.records) && Objects.equals(this.batchSize, that.batchSize) && Objects.equals(this.earliestLocalLogOffset, that.earliestLocalLogOffset);
    }

    public int hashCode() {
        return Objects.hash(this.records, this.batchSize, this.earliestLocalLogOffset);
    }
}

