/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tiered.storage.integration;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.tiered.storage.TieredStorageTestBuilder;
import org.apache.kafka.tiered.storage.TieredStorageTestHarness;
import org.apache.kafka.tiered.storage.specs.KeyValueSpec;

public class RollAndOffloadActiveSegmentTest
extends TieredStorageTestHarness {
    public int brokerCount() {
        return 1;
    }

    @Override
    protected void writeTestSpecifications(TieredStorageTestBuilder builder) {
        Integer broker0 = 0;
        String topicA = "topicA";
        Integer p0 = 0;
        Integer partitionCount = 1;
        Integer replicationFactor = 1;
        Integer maxBatchCountPerSegment = 1;
        Map<Integer, List<Integer>> replicaAssignment = null;
        boolean enableRemoteLogStorage = true;
        builder.createTopic("topicA", partitionCount, replicationFactor, maxBatchCountPerSegment, replicaAssignment, true).updateTopicConfig("topicA", this.configsToBeAdded(), Collections.emptyList()).expectSegmentToBeOffloaded(broker0, "topicA", p0, 0, new KeyValueSpec("k0", "v0")).expectSegmentToBeOffloaded(broker0, "topicA", p0, 1, new KeyValueSpec("k1", "v1")).expectSegmentToBeOffloaded(broker0, "topicA", p0, 2, new KeyValueSpec("k2", "v2")).expectSegmentToBeOffloaded(broker0, "topicA", p0, 3, new KeyValueSpec("k3", "v3")).expectEarliestLocalOffsetInLogDirectory("topicA", p0, 4L).produce("topicA", p0, new KeyValueSpec("k0", "v0"), new KeyValueSpec("k1", "v1"), new KeyValueSpec("k2", "v2"), new KeyValueSpec("k3", "v3")).expectFetchFromTieredStorage(broker0, "topicA", p0, 4).consume("topicA", p0, 0L, 4, 4);
    }

    private Map<String, String> configsToBeAdded() {
        HashMap<String, String> topicConfigs = new HashMap<String, String>();
        topicConfigs.put("local.retention.ms", "1");
        return topicConfigs;
    }
}

