/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tiered.storage.integration;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kafka.log.LogManager;
import kafka.server.ReplicaManager;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.tiered.storage.TieredStorageTestBuilder;
import org.apache.kafka.tiered.storage.TieredStorageTestHarness;
import org.apache.kafka.tiered.storage.specs.KeyValueSpec;

public class FetchFromLeaderWithCorruptedCheckpointTest
extends TieredStorageTestHarness {
    public int brokerCount() {
        return 2;
    }

    @Override
    protected void writeTestSpecifications(TieredStorageTestBuilder builder) {
        Integer broker0 = 0;
        Integer broker1 = 1;
        String topicA = "topicA";
        Integer p0 = 0;
        Integer partitionCount = 1;
        Integer replicationFactor = 2;
        Integer maxBatchCountPerSegment = 1;
        boolean enableRemoteLogStorage = true;
        Map assignment = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)p0, Arrays.asList(broker0, broker1))});
        List<String> checkpointFiles = Arrays.asList(ReplicaManager.HighWatermarkFilename(), LogManager.RecoveryPointCheckpointFile(), ".kafka_cleanshutdown");
        builder.createTopic("topicA", partitionCount, replicationFactor, maxBatchCountPerSegment, assignment, true).expectSegmentToBeOffloaded(broker0, "topicA", p0, 0, new KeyValueSpec("k0", "v0")).expectSegmentToBeOffloaded(broker0, "topicA", p0, 1, new KeyValueSpec("k1", "v1")).expectEarliestLocalOffsetInLogDirectory("topicA", p0, 2L).produce("topicA", p0, new KeyValueSpec("k0", "v0"), new KeyValueSpec("k1", "v1"), new KeyValueSpec("k2", "v2")).expectFetchFromTieredStorage(broker0, "topicA", p0, 2).consume("topicA", p0, 0L, 3, 2).stop(broker1).stop(broker0).eraseBrokerStorage(broker0, (dir, name) -> checkpointFiles.contains(name), true).start(broker0).start(broker1).expectSegmentToBeOffloaded(broker0, "topicA", p0, 3, new KeyValueSpec("k3", "v3")).expectEarliestLocalOffsetInLogDirectory("topicA", p0, 4L).produce("topicA", p0, new KeyValueSpec("k3", "v3"), new KeyValueSpec("k4", "v4")).expectFetchFromTieredStorage(broker0, "topicA", p0, 4).consume("topicA", p0, 0L, 5, 4);
    }
}

