/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tiered.storage.integration;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.tiered.storage.TieredStorageTestBuilder;
import org.apache.kafka.tiered.storage.TieredStorageTestHarness;
import org.apache.kafka.tiered.storage.specs.KeyValueSpec;

public final class AlterLogDirTest
extends TieredStorageTestHarness {
    public int brokerCount() {
        return 2;
    }

    @Override
    protected void writeTestSpecifications(TieredStorageTestBuilder builder) {
        String topicB = "topicB";
        boolean p0 = false;
        boolean partitionCount = true;
        int replicationFactor = 2;
        boolean maxBatchCountPerSegment = true;
        boolean enableRemoteLogStorage = true;
        boolean broker0 = false;
        boolean broker1 = true;
        builder.createTopic("topicB", 1, 2, 1, Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)0, Arrays.asList(1, 0))}), true).expectSegmentToBeOffloaded(1, "topicB", 0, 0, new KeyValueSpec("k0", "v0")).expectSegmentToBeOffloaded(1, "topicB", 0, 1, new KeyValueSpec("k1", "v1")).expectEarliestLocalOffsetInLogDirectory("topicB", 0, 2L).produce("topicB", 0, new KeyValueSpec("k0", "v0"), new KeyValueSpec("k1", "v1"), new KeyValueSpec("k2", "v2")).alterLogDir("topicB", 0, Collections.singletonList(0).get(0)).expectLeader("topicB", 0, 0, true).expectEarliestLocalOffsetInLogDirectory("topicB", 0, 3L).produce("topicB", 0, new KeyValueSpec("k3", "v3")).expectFetchFromTieredStorage(0, "topicB", 0, 3).consume("topicB", 0, 0L, 4, 3);
    }
}

