/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tiered.storage.actions;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import org.apache.kafka.clients.admin.NewPartitionReassignment;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.test.TestUtils;
import org.apache.kafka.tiered.storage.TieredStorageTestAction;
import org.apache.kafka.tiered.storage.TieredStorageTestContext;
import org.apache.kafka.tiered.storage.utils.TieredStorageTestUtils;

public final class ShrinkReplicaAction
implements TieredStorageTestAction {
    private final TopicPartition topicPartition;
    private final List<Integer> replicaIds;

    public ShrinkReplicaAction(TopicPartition topicPartition, List<Integer> replicaIds) {
        this.topicPartition = topicPartition;
        this.replicaIds = replicaIds;
    }

    @Override
    public void doExecute(TieredStorageTestContext context) throws InterruptedException, ExecutionException {
        String topic = this.topicPartition.topic();
        int partition = this.topicPartition.partition();
        TopicPartitionInfo partitionInfo = (TopicPartitionInfo)TieredStorageTestUtils.describeTopic(context, topic).partitions().get(partition);
        ArrayList currentReplicaIds = new ArrayList();
        ArrayList targetReplicaIds = new ArrayList();
        if (partitionInfo != null) {
            partitionInfo.replicas().forEach(node -> currentReplicaIds.add(node.id()));
            partitionInfo.replicas().stream().filter(node -> this.replicaIds.contains(node.id())).forEach(node -> targetReplicaIds.add(node.id()));
        }
        Map<TopicPartition, Optional<NewPartitionReassignment>> proposed = Collections.singletonMap(this.topicPartition, Optional.of(new NewPartitionReassignment(targetReplicaIds)));
        context.admin().alterPartitionReassignments(proposed).all().get();
        TestUtils.waitForCondition(() -> {
            HashSet actualReplicaIds = new HashSet();
            TopicPartitionInfo topicPartitionInfo = (TopicPartitionInfo)TieredStorageTestUtils.describeTopic(context, topic).partitions().get(partition);
            if (topicPartitionInfo != null) {
                topicPartitionInfo.replicas().forEach(node -> actualReplicaIds.add(node.id()));
            }
            return targetReplicaIds.size() == actualReplicaIds.size() && targetReplicaIds.containsAll(actualReplicaIds) && actualReplicaIds.containsAll(targetReplicaIds);
        }, (String)("Unable to shrink the replicas of " + this.topicPartition + ", replica-ids: " + this.replicaIds + ", actual-replica-ids: " + currentReplicaIds));
    }

    @Override
    public void describe(PrintStream output) {
        output.printf("shrink-replica topic-partition: %s replica-ids: %s%n", this.topicPartition, this.replicaIds);
    }
}

