/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tiered.storage.actions;

import java.io.PrintStream;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import kafka.log.UnifiedLog;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.storage.internals.epoch.LeaderEpochFileCache;
import org.apache.kafka.storage.internals.log.EpochEntry;
import org.apache.kafka.test.TestUtils;
import org.apache.kafka.tiered.storage.TieredStorageTestAction;
import org.apache.kafka.tiered.storage.TieredStorageTestContext;
import scala.Option;

public final class ExpectLeaderEpochCheckpointAction
implements TieredStorageTestAction {
    private final Integer brokerId;
    private final TopicPartition partition;
    private final Integer beginEpoch;
    private final Long startOffset;

    public ExpectLeaderEpochCheckpointAction(Integer brokerId, TopicPartition partition, Integer beginEpoch, Long startOffset) {
        this.brokerId = brokerId;
        this.partition = partition;
        this.beginEpoch = beginEpoch;
        this.startOffset = startOffset;
    }

    @Override
    public void doExecute(TieredStorageTestContext context) throws InterruptedException, ExecutionException {
        AtomicReference earliestEntryOpt = new AtomicReference();
        TestUtils.waitForCondition(() -> {
            Option leaderEpochCache;
            EpochEntry earliestEntry = null;
            Optional<UnifiedLog> log = context.log(this.brokerId, this.partition);
            if (log.isPresent() && (leaderEpochCache = log.get().leaderEpochCache()).isDefined()) {
                earliestEntry = ((LeaderEpochFileCache)leaderEpochCache.get()).earliestEntry().orElse(null);
            }
            earliestEntryOpt.set(earliestEntry);
            return earliestEntry != null && this.beginEpoch == earliestEntry.epoch && this.startOffset == earliestEntry.startOffset;
        }, (long)2000L, (String)("leader-epoch-checkpoint begin-epoch: " + this.beginEpoch + " and start-offset: " + this.startOffset + " doesn't match with actual: " + earliestEntryOpt.get()));
    }

    @Override
    public void describe(PrintStream output) {
        output.printf("expect-leader-epoch-checkpoint broker-id: %d, partition: %s, beginEpoch: %d, startOffset: %d%n", this.brokerId, this.partition, this.beginEpoch, this.startOffset);
    }
}

