/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tiered.storage.actions;

import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintStream;
import org.apache.kafka.tiered.storage.TieredStorageTestAction;
import org.apache.kafka.tiered.storage.TieredStorageTestContext;

public final class EraseBrokerStorageAction
implements TieredStorageTestAction {
    private final int brokerId;
    private final FilenameFilter filenameFilter;
    private final boolean isStopped;

    public EraseBrokerStorageAction(int brokerId) {
        this(brokerId, (dir, name) -> true, false);
    }

    public EraseBrokerStorageAction(int brokerId, FilenameFilter filenameFilter, boolean isStopped) {
        this.brokerId = brokerId;
        this.filenameFilter = filenameFilter;
        this.isStopped = isStopped;
    }

    @Override
    public void doExecute(TieredStorageTestContext context) throws IOException {
        context.eraseBrokerStorage(this.brokerId, this.filenameFilter, this.isStopped);
    }

    @Override
    public void describe(PrintStream output) {
        output.println("erase-broker-storage: " + this.brokerId + ", isStopped: " + this.isStopped + ", filenameFilter: " + this.filenameFilter);
    }
}

