/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tiered.storage.actions;

import java.io.File;
import java.io.PrintStream;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.kafka.clients.admin.AlterReplicaLogDirsResult;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionReplica;
import org.apache.kafka.test.TestUtils;
import org.apache.kafka.tiered.storage.TieredStorageTestAction;
import org.apache.kafka.tiered.storage.TieredStorageTestContext;
import org.apache.kafka.tiered.storage.utils.BrokerLocalStorage;

public final class AlterLogDirAction
implements TieredStorageTestAction {
    private final TopicPartition topicPartition;
    private final int brokerId;

    public AlterLogDirAction(TopicPartition topicPartition, int brokerId) {
        this.topicPartition = topicPartition;
        this.brokerId = brokerId;
    }

    @Override
    public void doExecute(TieredStorageTestContext context) throws InterruptedException, ExecutionException, TimeoutException {
        Optional<BrokerLocalStorage> localStorage = context.localStorages().stream().filter(storage -> storage.getBrokerId() == this.brokerId).findFirst();
        if (!localStorage.isPresent()) {
            throw new IllegalArgumentException("cannot find local storage for this topic partition:" + this.topicPartition + " in this broker id:" + this.brokerId);
        }
        Optional<File> sourceDir = localStorage.get().getBrokerStorageDirectories().stream().filter(dir -> ((BrokerLocalStorage)localStorage.get()).dirContainsTopicPartition(this.topicPartition, (File)dir)).findFirst();
        if (!sourceDir.isPresent()) {
            throw new IllegalArgumentException("No log dir with topic partition:" + this.topicPartition + " in this broker id:" + this.brokerId);
        }
        Optional<File> targetDir = localStorage.get().getBrokerStorageDirectories().stream().filter(dir -> !((BrokerLocalStorage)localStorage.get()).dirContainsTopicPartition(this.topicPartition, (File)dir)).findFirst();
        if (!targetDir.isPresent()) {
            throw new IllegalArgumentException("No log dir without topic partition:" + this.topicPartition + " in this broker id:" + this.brokerId);
        }
        TopicPartitionReplica topicPartitionReplica = new TopicPartitionReplica(this.topicPartition.topic(), this.topicPartition.partition(), this.brokerId);
        Map<TopicPartitionReplica, String> logDirs = Collections.singletonMap(topicPartitionReplica, targetDir.get().getAbsolutePath());
        AlterReplicaLogDirsResult results = context.admin().alterReplicaLogDirs(logDirs);
        ((KafkaFuture)results.values().get(topicPartitionReplica)).get(30L, TimeUnit.SECONDS);
        TestUtils.waitForCondition(() -> ((BrokerLocalStorage)localStorage.get()).dirContainsTopicPartition(this.topicPartition, (File)targetDir.get()) && !((BrokerLocalStorage)localStorage.get()).dirContainsTopicPartition(this.topicPartition, (File)sourceDir.get()), (String)("Failed to alter dir:" + logDirs));
    }

    @Override
    public void describe(PrintStream output) {
        output.print("alter dir for topic partition:" + this.topicPartition + " in this broker id:" + this.brokerId);
    }
}

