/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.storage.internals.utils;

import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.util.MockTime;
import org.apache.kafka.storage.internals.utils.Throttler;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ThrottlerTest {
    ThrottlerTest() {
    }

    @Test
    public void testThrottleDesiredRate() {
        long throttleCheckIntervalMs = 100L;
        double desiredCountPerSec = 1000.0;
        double desiredCountPerInterval = desiredCountPerSec * (double)throttleCheckIntervalMs / 1000.0;
        MockTime mockTime = new MockTime();
        Throttler throttler = new Throttler(desiredCountPerSec, throttleCheckIntervalMs, "throttler", "entries", (Time)mockTime);
        long t1 = mockTime.milliseconds();
        throttler.maybeThrottle(desiredCountPerInterval);
        Assertions.assertEquals((long)t1, (long)mockTime.milliseconds());
        mockTime.sleep(throttleCheckIntervalMs + 1L);
        throttler.maybeThrottle(desiredCountPerInterval);
        long t2 = mockTime.milliseconds();
        Assertions.assertTrue((t2 >= t1 + 2L * throttleCheckIntervalMs ? 1 : 0) != 0);
        throttler.maybeThrottle(desiredCountPerInterval);
        Assertions.assertEquals((long)t2, (long)mockTime.milliseconds());
        mockTime.sleep(throttleCheckIntervalMs + 1L);
        throttler.maybeThrottle(desiredCountPerInterval);
        long t3 = mockTime.milliseconds();
        Assertions.assertTrue((t3 >= t2 + 2L * throttleCheckIntervalMs ? 1 : 0) != 0);
        long elapsedTimeMs = t3 - t1;
        double actualCountPerSec = 4.0 * desiredCountPerInterval * 1000.0 / (double)elapsedTimeMs;
        Assertions.assertTrue((actualCountPerSec <= desiredCountPerSec ? 1 : 0) != 0);
    }

    @Test
    public void testUpdateThrottleDesiredRate() {
        long throttleCheckIntervalMs = 100L;
        double desiredCountPerSec = 1000.0;
        double desiredCountPerInterval = desiredCountPerSec * (double)throttleCheckIntervalMs / 1000.0;
        double updatedDesiredCountPerSec = 1500.0;
        double updatedDesiredCountPerInterval = updatedDesiredCountPerSec * (double)throttleCheckIntervalMs / 1000.0;
        MockTime mockTime = new MockTime();
        Throttler throttler = new Throttler(desiredCountPerSec, throttleCheckIntervalMs, "throttler", "entries", (Time)mockTime);
        long t1 = mockTime.milliseconds();
        throttler.maybeThrottle(desiredCountPerInterval);
        Assertions.assertEquals((long)t1, (long)mockTime.milliseconds());
        mockTime.sleep(throttleCheckIntervalMs + 1L);
        throttler.maybeThrottle(desiredCountPerInterval);
        long t2 = mockTime.milliseconds();
        Assertions.assertTrue((t2 >= t1 + 2L * throttleCheckIntervalMs ? 1 : 0) != 0);
        long elapsedTimeMs = t2 - t1;
        double actualCountPerSec = 2.0 * desiredCountPerInterval * 1000.0 / (double)elapsedTimeMs;
        Assertions.assertTrue((actualCountPerSec <= desiredCountPerSec ? 1 : 0) != 0);
        throttler.updateDesiredRatePerSec(updatedDesiredCountPerSec);
        throttler.maybeThrottle(updatedDesiredCountPerInterval);
        Assertions.assertEquals((long)t2, (long)mockTime.milliseconds());
        mockTime.sleep(throttleCheckIntervalMs + 1L);
        throttler.maybeThrottle(updatedDesiredCountPerInterval);
        long t3 = mockTime.milliseconds();
        Assertions.assertTrue((t3 >= t2 + 2L * throttleCheckIntervalMs ? 1 : 0) != 0);
        long updatedElapsedTimeMs = t3 - t2;
        double updatedActualCountPerSec = 2.0 * updatedDesiredCountPerInterval * 1000.0 / (double)updatedElapsedTimeMs;
        Assertions.assertTrue((updatedActualCountPerSec <= updatedDesiredCountPerSec ? 1 : 0) != 0);
    }
}

