/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.storage.internals.log;

import org.apache.kafka.common.KafkaException;
import org.apache.kafka.storage.internals.log.LogOffsetMetadata;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class LogOffsetMetadataTest {
    LogOffsetMetadataTest() {
    }

    @Test
    void testOnOlderSegment() {
        LogOffsetMetadata metadata1 = new LogOffsetMetadata(1L, 0L, 1);
        LogOffsetMetadata metadata2 = new LogOffsetMetadata(5L, 4L, 2);
        LogOffsetMetadata messageOnlyMetadata = new LogOffsetMetadata(1L);
        Assertions.assertFalse((boolean)LogOffsetMetadata.UNKNOWN_OFFSET_METADATA.onOlderSegment(LogOffsetMetadata.UNKNOWN_OFFSET_METADATA));
        Assertions.assertFalse((boolean)metadata1.onOlderSegment(messageOnlyMetadata));
        Assertions.assertFalse((boolean)messageOnlyMetadata.onOlderSegment(metadata1));
        Assertions.assertFalse((boolean)metadata1.onOlderSegment(metadata1));
        Assertions.assertFalse((boolean)metadata2.onOlderSegment(metadata1));
        Assertions.assertTrue((boolean)metadata1.onOlderSegment(metadata2));
    }

    @Test
    void testPositionDiff() {
        LogOffsetMetadata metadata1 = new LogOffsetMetadata(1L);
        LogOffsetMetadata metadata2 = new LogOffsetMetadata(5L, 0L, 5);
        KafkaException exception = (KafkaException)Assertions.assertThrows(KafkaException.class, () -> metadata1.positionDiff(metadata2));
        Assertions.assertTrue((boolean)exception.getMessage().endsWith("since it only has message offset info"));
        exception = (KafkaException)Assertions.assertThrows(KafkaException.class, () -> metadata2.positionDiff(metadata1));
        Assertions.assertTrue((boolean)exception.getMessage().endsWith("since it only has message offset info"));
        LogOffsetMetadata metadata3 = new LogOffsetMetadata(15L, 10L, 5);
        exception = (KafkaException)Assertions.assertThrows(KafkaException.class, () -> metadata3.positionDiff(metadata2));
        Assertions.assertTrue((boolean)exception.getMessage().endsWith("since they are not on the same segment"));
        LogOffsetMetadata metadata4 = new LogOffsetMetadata(40L, 10L, 100);
        Assertions.assertEquals((int)95, (int)metadata4.positionDiff(metadata3));
    }

    @Test
    void testMessageOffsetOnly() {
        LogOffsetMetadata metadata1 = new LogOffsetMetadata(1L);
        LogOffsetMetadata metadata2 = new LogOffsetMetadata(1L, 0L, 1);
        Assertions.assertTrue((boolean)LogOffsetMetadata.UNKNOWN_OFFSET_METADATA.messageOffsetOnly());
        Assertions.assertFalse((boolean)metadata2.messageOffsetOnly());
        Assertions.assertTrue((boolean)metadata1.messageOffsetOnly());
    }

    @Test
    void testOnSameSegment() {
        LogOffsetMetadata metadata1 = new LogOffsetMetadata(1L, 0L, 1);
        LogOffsetMetadata metadata2 = new LogOffsetMetadata(5L, 4L, 2);
        LogOffsetMetadata metadata3 = new LogOffsetMetadata(10L, 4L, 200);
        Assertions.assertFalse((boolean)metadata1.onSameSegment(metadata2));
        Assertions.assertTrue((boolean)metadata2.onSameSegment(metadata3));
        LogOffsetMetadata metadata4 = new LogOffsetMetadata(50L);
        LogOffsetMetadata metadata5 = new LogOffsetMetadata(100L);
        Assertions.assertFalse((boolean)metadata4.onSameSegment(metadata5));
    }
}

