/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.storage.internals.checkpoint;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.List;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.InconsistentTopicIdException;
import org.apache.kafka.storage.internals.checkpoint.PartitionMetadata;
import org.apache.kafka.storage.internals.checkpoint.PartitionMetadataFile;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class PartitionMetadataFileTest {
    private final File dir = TestUtils.tempDirectory();
    private final File file = PartitionMetadataFile.newFile((File)this.dir);

    PartitionMetadataFileTest() {
    }

    @Test
    public void testSetRecordWithDifferentTopicId() {
        PartitionMetadataFile partitionMetadataFile = new PartitionMetadataFile(this.file, null);
        Uuid topicId = Uuid.randomUuid();
        partitionMetadataFile.record(topicId);
        Uuid differentTopicId = Uuid.randomUuid();
        Assertions.assertThrows(InconsistentTopicIdException.class, () -> partitionMetadataFile.record(differentTopicId));
    }

    @Test
    public void testSetRecordWithSameTopicId() {
        PartitionMetadataFile partitionMetadataFile = new PartitionMetadataFile(this.file, null);
        Uuid topicId = Uuid.randomUuid();
        partitionMetadataFile.record(topicId);
        Assertions.assertDoesNotThrow(() -> partitionMetadataFile.record(topicId));
        Uuid sameTopicId = Uuid.fromString((String)topicId.toString());
        partitionMetadataFile.record(sameTopicId);
        Assertions.assertDoesNotThrow(() -> partitionMetadataFile.record(topicId));
    }

    @Test
    public void testMaybeFlushWithTopicIdPresent() throws IOException {
        PartitionMetadataFile partitionMetadataFile = new PartitionMetadataFile(this.file, null);
        Uuid topicId = Uuid.randomUuid();
        partitionMetadataFile.record(topicId);
        partitionMetadataFile.maybeFlush();
        List<String> lines = Files.readAllLines(this.file.toPath());
        Assertions.assertEquals((int)2, (int)lines.size());
        Assertions.assertEquals((Object)"version: 0", (Object)lines.get(0));
        Assertions.assertEquals((Object)("topic_id: " + topicId), (Object)lines.get(1));
    }

    @Test
    public void testMaybeFlushWithNoTopicIdPresent() {
        PartitionMetadataFile partitionMetadataFile = new PartitionMetadataFile(this.file, null);
        partitionMetadataFile.maybeFlush();
        Assertions.assertEquals((long)0L, (long)this.file.length());
    }

    @Test
    public void testRead() {
        LogDirFailureChannel channel = (LogDirFailureChannel)Mockito.mock(LogDirFailureChannel.class);
        PartitionMetadataFile partitionMetadataFile = new PartitionMetadataFile(this.file, channel);
        Uuid topicId = Uuid.randomUuid();
        partitionMetadataFile.record(topicId);
        partitionMetadataFile.maybeFlush();
        PartitionMetadata metadata = partitionMetadataFile.read();
        Assertions.assertEquals((int)0, (int)metadata.version());
        Assertions.assertEquals((Object)topicId, (Object)metadata.topicId());
    }
}

