/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.log.remote.storage;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import kafka.test.ClusterInstance;
import kafka.test.annotation.ClusterTest;
import kafka.test.annotation.ClusterTestDefaults;
import kafka.test.junit.ClusterTestExtensions;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.utils.SystemTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.log.remote.metadata.storage.RemoteLogMetadataManagerTestUtils;
import org.apache.kafka.server.log.remote.metadata.storage.RemotePartitionMetadataStore;
import org.apache.kafka.server.log.remote.metadata.storage.TopicBasedRemoteLogMetadataManager;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentId;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentMetadata;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentMetadataUpdate;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentState;
import org.apache.kafka.server.log.remote.storage.RemotePartitionDeleteMetadata;
import org.apache.kafka.server.log.remote.storage.RemotePartitionDeleteState;
import org.apache.kafka.server.log.remote.storage.RemoteResourceNotFoundException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.extension.ExtendWith;

@Tag(value="integration")
@ExtendWith(value={ClusterTestExtensions.class})
@ClusterTestDefaults(brokers=3)
public class RemoteLogMetadataManagerTest {
    private final ClusterInstance clusterInstance;
    private static final TopicIdPartition TP0 = new TopicIdPartition(Uuid.randomUuid(), new TopicPartition("foo", 0));
    private static final int SEG_SIZE = 0x100000;
    private static final int BROKER_ID_0 = 0;
    private static final int BROKER_ID_1 = 1;
    private final Time time = new SystemTime();

    RemoteLogMetadataManagerTest(ClusterInstance clusterInstance) {
        this.clusterInstance = clusterInstance;
    }

    private TopicBasedRemoteLogMetadataManager topicBasedRlmm() {
        return RemoteLogMetadataManagerTestUtils.builder().bootstrapServers(this.clusterInstance.bootstrapServers()).startConsumerThread(true).remotePartitionMetadataStore(RemotePartitionMetadataStore::new).build();
    }

    @ClusterTest
    public void testFetchSegments() throws Exception {
        try (TopicBasedRemoteLogMetadataManager remoteLogMetadataManager = this.topicBasedRlmm();){
            remoteLogMetadataManager.onPartitionLeadershipChanges(Collections.singleton(TP0), Collections.emptySet());
            Map<Integer, Long> segmentLeaderEpochs = Collections.singletonMap(0, 101L);
            RemoteLogSegmentId segmentId = new RemoteLogSegmentId(TP0, Uuid.randomUuid());
            RemoteLogSegmentMetadata segmentMetadata = new RemoteLogSegmentMetadata(segmentId, 101L, 200L, -1L, 0, this.time.milliseconds(), 0x100000, segmentLeaderEpochs);
            Assertions.assertDoesNotThrow(() -> (Void)remoteLogMetadataManager.addRemoteLogSegmentMetadata(segmentMetadata).get());
            Assertions.assertFalse((boolean)remoteLogMetadataManager.remoteLogSegmentMetadata(TP0, 0, 150L).isPresent());
            RemoteLogSegmentMetadataUpdate segmentMetadataUpdate = new RemoteLogSegmentMetadataUpdate(segmentId, this.time.milliseconds(), Optional.empty(), RemoteLogSegmentState.COPY_SEGMENT_FINISHED, 1);
            Assertions.assertDoesNotThrow(() -> (Void)remoteLogMetadataManager.updateRemoteLogSegmentMetadata(segmentMetadataUpdate).get());
            RemoteLogSegmentMetadata expectedSegmentMetadata = segmentMetadata.createWithUpdates(segmentMetadataUpdate);
            Optional segmentMetadataForOffset150 = remoteLogMetadataManager.remoteLogSegmentMetadata(TP0, 0, 150L);
            Assertions.assertEquals(Optional.of(expectedSegmentMetadata), (Object)segmentMetadataForOffset150);
        }
    }

    @ClusterTest
    public void testRemotePartitionDeletion() throws Exception {
        try (TopicBasedRemoteLogMetadataManager remoteLogMetadataManager = this.topicBasedRlmm();){
            remoteLogMetadataManager.configure(Collections.emptyMap());
            remoteLogMetadataManager.onPartitionLeadershipChanges(Collections.singleton(TP0), Collections.emptySet());
            HashMap<Integer, Long> segmentLeaderEpochs = new HashMap<Integer, Long>();
            segmentLeaderEpochs.put(0, 0L);
            segmentLeaderEpochs.put(1, 20L);
            segmentLeaderEpochs.put(2, 50L);
            segmentLeaderEpochs.put(3, 80L);
            RemoteLogSegmentId segmentId = new RemoteLogSegmentId(TP0, Uuid.randomUuid());
            RemoteLogSegmentMetadata segmentMetadata = new RemoteLogSegmentMetadata(segmentId, 0L, 100L, -1L, 0, this.time.milliseconds(), 0x100000, segmentLeaderEpochs);
            Assertions.assertDoesNotThrow(() -> (Void)remoteLogMetadataManager.addRemoteLogSegmentMetadata(segmentMetadata).get());
            RemoteLogSegmentMetadataUpdate segmentMetadataUpdate = new RemoteLogSegmentMetadataUpdate(segmentId, this.time.milliseconds(), Optional.empty(), RemoteLogSegmentState.COPY_SEGMENT_FINISHED, 1);
            Assertions.assertDoesNotThrow(() -> (Void)remoteLogMetadataManager.updateRemoteLogSegmentMetadata(segmentMetadataUpdate).get());
            RemoteLogSegmentMetadata expectedSegMetadata = segmentMetadata.createWithUpdates(segmentMetadataUpdate);
            Optional segMetadataForOffset30Epoch1 = remoteLogMetadataManager.remoteLogSegmentMetadata(TP0, 1, 30L);
            Assertions.assertEquals(Optional.of(expectedSegMetadata), (Object)segMetadataForOffset30Epoch1);
            Assertions.assertDoesNotThrow(() -> (Void)remoteLogMetadataManager.putRemotePartitionDeleteMetadata(this.createRemotePartitionDeleteMetadata(RemotePartitionDeleteState.DELETE_PARTITION_MARKED)).get());
            Optional segmentMetadataAfterDelMark = remoteLogMetadataManager.remoteLogSegmentMetadata(TP0, 1, 30L);
            Assertions.assertEquals(Optional.of(expectedSegMetadata), (Object)segmentMetadataAfterDelMark);
            Assertions.assertDoesNotThrow(() -> (Void)remoteLogMetadataManager.putRemotePartitionDeleteMetadata(this.createRemotePartitionDeleteMetadata(RemotePartitionDeleteState.DELETE_PARTITION_STARTED)).get());
            Optional segmentMetadataAfterDelStart = remoteLogMetadataManager.remoteLogSegmentMetadata(TP0, 1, 30L);
            Assertions.assertEquals(Optional.of(expectedSegMetadata), (Object)segmentMetadataAfterDelStart);
            Assertions.assertDoesNotThrow(() -> (Void)remoteLogMetadataManager.putRemotePartitionDeleteMetadata(this.createRemotePartitionDeleteMetadata(RemotePartitionDeleteState.DELETE_PARTITION_FINISHED)).get());
            Assertions.assertThrows(RemoteResourceNotFoundException.class, () -> remoteLogMetadataManager.remoteLogSegmentMetadata(TP0, 1, 30L));
        }
    }

    private RemotePartitionDeleteMetadata createRemotePartitionDeleteMetadata(RemotePartitionDeleteState state) {
        return new RemotePartitionDeleteMetadata(TP0, state, this.time.milliseconds(), 0);
    }
}

