/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.log.remote.storage;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.server.log.remote.storage.RemoteLogManagerConfig;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RemoteLogManagerConfigTest {
    @Test
    public void testValidConfigs() {
        String rsmPrefix = "__custom.rsm.";
        String rlmmPrefix = "__custom.rlmm.";
        Map<String, String> rsmProps = Collections.singletonMap("rsm.prop", "val");
        Map<String, String> rlmmProps = Collections.singletonMap("rlmm.prop", "val");
        Map<String, Object> props = this.getRLMProps(rsmPrefix, rlmmPrefix);
        rsmProps.forEach((k, v) -> props.put(rsmPrefix + k, v));
        rlmmProps.forEach((k, v) -> props.put(rlmmPrefix + k, v));
        RemoteLogManagerConfig expectedRemoteLogManagerConfig = new RemoteLogManagerConfig(props);
        props.remove("remote.log.metadata.manager.class.name");
        RemoteLogManagerConfig remoteLogManagerConfig = new RemoteLogManagerConfig(props);
        Assertions.assertEquals((Object)expectedRemoteLogManagerConfig.values(), (Object)remoteLogManagerConfig.values());
        Assertions.assertEquals(rsmProps, (Object)remoteLogManagerConfig.remoteStorageManagerProps());
        Assertions.assertEquals(rlmmProps, (Object)remoteLogManagerConfig.remoteLogMetadataManagerProps());
    }

    @Test
    public void testDefaultConfigs() {
        HashMap emptyProps = new HashMap();
        RemoteLogManagerConfig remoteLogManagerConfigEmptyConfig = new RemoteLogManagerConfig(emptyProps);
        Assertions.assertEquals((int)10, (int)remoteLogManagerConfigEmptyConfig.remoteLogManagerThreadPoolSize());
        Assertions.assertEquals((int)11, (int)remoteLogManagerConfigEmptyConfig.remoteLogManagerCopyNumQuotaSamples());
    }

    @Test
    public void testValidateEmptyStringConfig() {
        Map<String, String> emptyStringProps = Collections.singletonMap("remote.log.metadata.manager.listener.name", "");
        Assertions.assertThrows(ConfigException.class, () -> new RemoteLogManagerConfig(emptyStringProps));
    }

    private Map<String, Object> getRLMProps(String rsmPrefix, String rlmmPrefix) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("remote.log.storage.system.enable", true);
        props.put("remote.log.storage.manager.class.name", "dummy.remote.storage.class");
        props.put("remote.log.storage.manager.class.path", "dummy.remote.storage.class.path");
        props.put("remote.log.metadata.manager.class.name", "org.apache.kafka.server.log.remote.metadata.storage.TopicBasedRemoteLogMetadataManager");
        props.put("remote.log.metadata.manager.class.path", "dummy.remote.log.metadata.class.path");
        props.put("remote.log.metadata.manager.listener.name", "listener.name");
        props.put("remote.log.index.file.cache.total.size.bytes", 0x100000L);
        props.put("remote.log.manager.thread.pool.size", 1);
        props.put("remote.log.manager.copier.thread.pool.size", 1);
        props.put("remote.log.manager.expiration.thread.pool.size", 1);
        props.put("remote.log.manager.task.interval.ms", 60000L);
        props.put("remote.log.manager.task.retry.backoff.ms", 100L);
        props.put("remote.log.manager.task.retry.backoff.max.ms", 60000L);
        props.put("remote.log.manager.task.retry.jitter", 0.3);
        props.put("remote.log.reader.threads", 10);
        props.put("remote.log.reader.max.pending.tasks", 100);
        props.put("remote.log.metadata.custom.metadata.max.bytes", 100);
        props.put("remote.log.storage.manager.impl.prefix", rsmPrefix);
        props.put("remote.log.metadata.manager.impl.prefix", rlmmPrefix);
        return props;
    }
}

