/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.log.remote.storage;

import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.server.log.remote.storage.LocalTieredStorage;
import org.apache.kafka.server.log.remote.storage.LocalTieredStorageEvent;
import org.apache.kafka.server.log.remote.storage.LocalTieredStorageListener;

public final class LocalTieredStorageCondition {
    final LocalTieredStorageEvent.EventType eventType;
    final int brokerId;
    final TopicPartition topicPartition;
    final Integer baseOffset;
    final boolean failed;
    private final InternalListener listener;
    private final LocalTieredStorageCondition next;

    public static LocalTieredStorageCondition expectEvent(Iterable<LocalTieredStorage> storages, LocalTieredStorageEvent.EventType eventType, int brokerId, TopicPartition tp, Integer baseOffset, boolean failed) {
        LocalTieredStorageCondition condition = new LocalTieredStorageCondition(eventType, brokerId, tp, failed, baseOffset, 1);
        storages.forEach(storage -> storage.addListener(condition.listener));
        return condition;
    }

    public static LocalTieredStorageCondition expectEvent(Iterable<LocalTieredStorage> storages, LocalTieredStorageEvent.EventType eventType, int brokerId, TopicPartition tp, boolean failed, int latchCount) {
        LocalTieredStorageCondition condition = new LocalTieredStorageCondition(eventType, brokerId, tp, failed, null, latchCount);
        storages.forEach(storage -> storage.addListener(condition.listener));
        return condition;
    }

    public LocalTieredStorageCondition and(LocalTieredStorageCondition conjuct) {
        if (conjuct.next != null) {
            throw new IllegalArgumentException(String.format("The condition %s is already composed, cannot add it to %s", conjuct, this));
        }
        if (conjuct == this) {
            throw new IllegalArgumentException(String.format("The condition %s cannot be added to itself", this));
        }
        return new LocalTieredStorageCondition(this, this.next != null ? this.next.and(conjuct) : conjuct);
    }

    public void waitUntilTrue(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        long start = System.currentTimeMillis();
        if (!this.listener.awaitEvent(timeout, unit)) {
            throw new TimeoutException(String.format("Time out reached before condition was verified %s", this));
        }
        if (this.next != null) {
            long end = System.currentTimeMillis();
            long timeElapsed = unit.convert(end - start, TimeUnit.MILLISECONDS);
            this.next.waitUntilTrue(Math.max(0L, timeout - timeElapsed), unit);
        }
    }

    public String toString() {
        return String.format("Condition[eventType=%s, brokerId=%d, topicPartition=%s, baseOffset=%d, failed=%b]", new Object[]{this.eventType, this.brokerId, this.topicPartition, this.baseOffset, this.failed});
    }

    private LocalTieredStorageCondition(LocalTieredStorageEvent.EventType type, int id, TopicPartition tp, boolean failed, Integer baseOffset, int latchCount) {
        this.eventType = Objects.requireNonNull(type);
        this.brokerId = id;
        this.topicPartition = Objects.requireNonNull(tp);
        this.failed = failed;
        this.baseOffset = baseOffset;
        this.listener = new InternalListener(this, latchCount);
        this.next = null;
    }

    private LocalTieredStorageCondition(LocalTieredStorageCondition h, LocalTieredStorageCondition next) {
        this.eventType = h.eventType;
        this.brokerId = h.brokerId;
        this.topicPartition = h.topicPartition;
        this.failed = h.failed;
        this.baseOffset = h.baseOffset;
        this.listener = h.listener;
        this.next = Objects.requireNonNull(next);
    }

    private static final class InternalListener
    implements LocalTieredStorageListener {
        private final CountDownLatch latch;
        private final LocalTieredStorageCondition condition;

        @Override
        public void onStorageEvent(LocalTieredStorageEvent event) {
            if (event.matches(this.condition)) {
                this.latch.countDown();
            }
        }

        private boolean awaitEvent(long timeout, TimeUnit unit) throws InterruptedException {
            return this.latch.await(timeout, unit);
        }

        private InternalListener(LocalTieredStorageCondition condition, int latchCount) {
            this.condition = Objects.requireNonNull(condition);
            this.latch = new CountDownLatch(latchCount);
        }
    }
}

