/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.log.remote.metadata.storage;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import kafka.test.ClusterInstance;
import kafka.test.annotation.ClusterTest;
import kafka.test.annotation.ClusterTestDefaults;
import kafka.test.junit.ClusterTestExtensions;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.utils.SystemTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.log.remote.metadata.storage.RemoteLogMetadataManagerTestUtils;
import org.apache.kafka.server.log.remote.metadata.storage.RemotePartitionMetadataStore;
import org.apache.kafka.server.log.remote.metadata.storage.TopicBasedRemoteLogMetadataManager;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentId;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentMetadata;
import org.apache.kafka.server.log.remote.storage.RemoteResourceNotFoundException;
import org.apache.kafka.server.log.remote.storage.RemoteStorageException;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

@ExtendWith(value={ClusterTestExtensions.class})
@ClusterTestDefaults(brokers=3)
public class TopicBasedRemoteLogMetadataManagerTest {
    private static final int SEG_SIZE = 0x100000;
    private final ClusterInstance clusterInstance;
    private final RemotePartitionMetadataStore spyRemotePartitionMetadataEventHandler = (RemotePartitionMetadataStore)Mockito.spy((Object)new RemotePartitionMetadataStore());
    private final Time time = new SystemTime();
    private TopicBasedRemoteLogMetadataManager remoteLogMetadataManager;

    TopicBasedRemoteLogMetadataManagerTest(ClusterInstance clusterInstance) {
        this.clusterInstance = clusterInstance;
    }

    private TopicBasedRemoteLogMetadataManager topicBasedRlmm() {
        if (this.remoteLogMetadataManager == null) {
            this.remoteLogMetadataManager = RemoteLogMetadataManagerTestUtils.builder().bootstrapServers(this.clusterInstance.bootstrapServers()).startConsumerThread(true).remotePartitionMetadataStore(() -> this.spyRemotePartitionMetadataEventHandler).build();
        }
        return this.remoteLogMetadataManager;
    }

    @AfterEach
    public void teardown() throws IOException {
        if (this.remoteLogMetadataManager != null) {
            this.remoteLogMetadataManager.close();
        }
    }

    @ClusterTest
    public void testDoesTopicExist() throws ExecutionException, InterruptedException {
        try (Admin admin = this.clusterInstance.createAdminClient();){
            String topic = "test-topic-exist";
            admin.createTopics(Collections.singletonList(new NewTopic(topic, 1, 1))).all().get();
            this.clusterInstance.waitForTopic(topic, 1);
            boolean doesTopicExist = this.topicBasedRlmm().doesTopicExist(admin, topic);
            Assertions.assertTrue((boolean)doesTopicExist);
        }
    }

    @ClusterTest
    public void testTopicDoesNotExist() {
        try (Admin admin = this.clusterInstance.createAdminClient();){
            String topic = "dummy-test-topic";
            boolean doesTopicExist = this.topicBasedRlmm().doesTopicExist(admin, topic);
            Assertions.assertFalse((boolean)doesTopicExist);
        }
    }

    @ClusterTest
    public void testWithNoAssignedPartitions() {
        this.topicBasedRlmm();
    }

    @ClusterTest
    public void testNewPartitionUpdates() throws Exception {
        String leaderTopic = "new-leader";
        String followerTopic = "new-follower";
        try (Admin admin = this.clusterInstance.createAdminClient();){
            admin.createTopics(Collections.singletonList(new NewTopic(leaderTopic, Collections.singletonMap(0, Arrays.asList(0, 1, 2))))).all().get();
            this.clusterInstance.waitForTopic(leaderTopic, 1);
            admin.createTopics(Collections.singletonList(new NewTopic(followerTopic, Collections.singletonMap(0, Arrays.asList(1, 2, 0))))).all().get();
            this.clusterInstance.waitForTopic(followerTopic, 1);
        }
        TopicIdPartition newLeaderTopicIdPartition = new TopicIdPartition(Uuid.randomUuid(), new TopicPartition(leaderTopic, 0));
        TopicIdPartition newFollowerTopicIdPartition = new TopicIdPartition(Uuid.randomUuid(), new TopicPartition(followerTopic, 0));
        CountDownLatch initializationLatch = new CountDownLatch(2);
        ((RemotePartitionMetadataStore)Mockito.doAnswer(invocationOnMock -> {
            Object result = invocationOnMock.callRealMethod();
            initializationLatch.countDown();
            return result;
        }).when((Object)this.spyRemotePartitionMetadataEventHandler)).markInitialized((TopicIdPartition)ArgumentMatchers.any());
        CountDownLatch handleRemoteLogSegmentMetadataLatch = new CountDownLatch(2);
        ((RemotePartitionMetadataStore)Mockito.doAnswer(invocationOnMock -> {
            Object result = invocationOnMock.callRealMethod();
            handleRemoteLogSegmentMetadataLatch.countDown();
            return result;
        }).when((Object)this.spyRemotePartitionMetadataEventHandler)).handleRemoteLogSegmentMetadata((RemoteLogSegmentMetadata)ArgumentMatchers.any());
        RemoteLogSegmentMetadata leaderSegmentMetadata = new RemoteLogSegmentMetadata(new RemoteLogSegmentId(newLeaderTopicIdPartition, Uuid.randomUuid()), 0L, 100L, -1L, 0, this.time.milliseconds(), 0x100000, Collections.singletonMap(0, 0L));
        Assertions.assertThrows(Exception.class, () -> {
            Void cfr_ignored_0 = (Void)this.topicBasedRlmm().addRemoteLogSegmentMetadata(leaderSegmentMetadata).get();
        });
        RemoteLogSegmentMetadata followerSegmentMetadata = new RemoteLogSegmentMetadata(new RemoteLogSegmentId(newFollowerTopicIdPartition, Uuid.randomUuid()), 0L, 100L, -1L, 0, this.time.milliseconds(), 0x100000, Collections.singletonMap(0, 0L));
        Assertions.assertThrows(Exception.class, () -> {
            Void cfr_ignored_0 = (Void)this.topicBasedRlmm().addRemoteLogSegmentMetadata(followerSegmentMetadata).get();
        });
        Assertions.assertThrows(RemoteResourceNotFoundException.class, () -> this.topicBasedRlmm().listRemoteLogSegments(newLeaderTopicIdPartition));
        Assertions.assertThrows(RemoteResourceNotFoundException.class, () -> this.topicBasedRlmm().listRemoteLogSegments(newFollowerTopicIdPartition));
        this.topicBasedRlmm().onPartitionLeadershipChanges(Collections.singleton(newLeaderTopicIdPartition), Collections.singleton(newFollowerTopicIdPartition));
        Assertions.assertTrue((boolean)initializationLatch.await(30000L, TimeUnit.MILLISECONDS));
        Assertions.assertTrue((boolean)handleRemoteLogSegmentMetadataLatch.await(30000L, TimeUnit.MILLISECONDS));
        ((RemotePartitionMetadataStore)Mockito.verify((Object)this.spyRemotePartitionMetadataEventHandler)).markInitialized(newLeaderTopicIdPartition);
        ((RemotePartitionMetadataStore)Mockito.verify((Object)this.spyRemotePartitionMetadataEventHandler)).markInitialized(newFollowerTopicIdPartition);
        ((RemotePartitionMetadataStore)Mockito.verify((Object)this.spyRemotePartitionMetadataEventHandler)).handleRemoteLogSegmentMetadata(leaderSegmentMetadata);
        ((RemotePartitionMetadataStore)Mockito.verify((Object)this.spyRemotePartitionMetadataEventHandler)).handleRemoteLogSegmentMetadata(followerSegmentMetadata);
        Assertions.assertTrue((boolean)this.topicBasedRlmm().listRemoteLogSegments(newLeaderTopicIdPartition).hasNext());
        Assertions.assertTrue((boolean)this.topicBasedRlmm().listRemoteLogSegments(newFollowerTopicIdPartition).hasNext());
    }

    @ClusterTest
    public void testRemoteLogSizeCalculationForUnknownTopicIdPartitionThrows() {
        TopicIdPartition topicIdPartition = new TopicIdPartition(Uuid.randomUuid(), new TopicPartition("singleton", 0));
        Assertions.assertThrows(RemoteResourceNotFoundException.class, () -> this.topicBasedRlmm().remoteLogSize(topicIdPartition, 0));
    }

    @ClusterTest
    public void testRemoteLogSizeCalculationWithSegmentsOfTheSameEpoch() throws RemoteStorageException, InterruptedException {
        TopicIdPartition topicIdPartition = new TopicIdPartition(Uuid.randomUuid(), new TopicPartition("singleton", 0));
        TopicBasedRemoteLogMetadataManager topicBasedRemoteLogMetadataManager = this.topicBasedRlmm();
        CountDownLatch initializationLatch = new CountDownLatch(1);
        ((RemotePartitionMetadataStore)Mockito.doAnswer(invocationOnMock -> {
            Object result = invocationOnMock.callRealMethod();
            initializationLatch.countDown();
            return result;
        }).when((Object)this.spyRemotePartitionMetadataEventHandler)).markInitialized((TopicIdPartition)ArgumentMatchers.any());
        CountDownLatch handleRemoteLogSegmentMetadataLatch = new CountDownLatch(3);
        ((RemotePartitionMetadataStore)Mockito.doAnswer(invocationOnMock -> {
            Object result = invocationOnMock.callRealMethod();
            handleRemoteLogSegmentMetadataLatch.countDown();
            return result;
        }).when((Object)this.spyRemotePartitionMetadataEventHandler)).handleRemoteLogSegmentMetadata((RemoteLogSegmentMetadata)ArgumentMatchers.any());
        RemoteLogSegmentMetadata firstSegmentMetadata = new RemoteLogSegmentMetadata(new RemoteLogSegmentId(topicIdPartition, Uuid.randomUuid()), 0L, 100L, -1L, 0, this.time.milliseconds(), 0x100000, Collections.singletonMap(0, 0L));
        RemoteLogSegmentMetadata secondSegmentMetadata = new RemoteLogSegmentMetadata(new RemoteLogSegmentId(topicIdPartition, Uuid.randomUuid()), 100L, 200L, -1L, 0, this.time.milliseconds(), 0x200000, Collections.singletonMap(0, 0L));
        RemoteLogSegmentMetadata thirdSegmentMetadata = new RemoteLogSegmentMetadata(new RemoteLogSegmentId(topicIdPartition, Uuid.randomUuid()), 200L, 300L, -1L, 0, this.time.milliseconds(), 0x300000, Collections.singletonMap(0, 0L));
        topicBasedRemoteLogMetadataManager.addRemoteLogSegmentMetadata(firstSegmentMetadata);
        topicBasedRemoteLogMetadataManager.addRemoteLogSegmentMetadata(secondSegmentMetadata);
        topicBasedRemoteLogMetadataManager.addRemoteLogSegmentMetadata(thirdSegmentMetadata);
        topicBasedRemoteLogMetadataManager.onPartitionLeadershipChanges(Collections.singleton(topicIdPartition), Collections.emptySet());
        Assertions.assertTrue((boolean)initializationLatch.await(30000L, TimeUnit.MILLISECONDS));
        Assertions.assertTrue((boolean)handleRemoteLogSegmentMetadataLatch.await(30000L, TimeUnit.MILLISECONDS));
        ((RemotePartitionMetadataStore)Mockito.verify((Object)this.spyRemotePartitionMetadataEventHandler)).markInitialized(topicIdPartition);
        ((RemotePartitionMetadataStore)Mockito.verify((Object)this.spyRemotePartitionMetadataEventHandler)).handleRemoteLogSegmentMetadata(firstSegmentMetadata);
        ((RemotePartitionMetadataStore)Mockito.verify((Object)this.spyRemotePartitionMetadataEventHandler)).handleRemoteLogSegmentMetadata(secondSegmentMetadata);
        ((RemotePartitionMetadataStore)Mockito.verify((Object)this.spyRemotePartitionMetadataEventHandler)).handleRemoteLogSegmentMetadata(thirdSegmentMetadata);
        Long remoteLogSize = topicBasedRemoteLogMetadataManager.remoteLogSize(topicIdPartition, 0);
        Assertions.assertEquals((long)0x600000L, (Long)remoteLogSize);
    }

    @ClusterTest
    public void testRemoteLogSizeCalculationWithSegmentsOfDifferentEpochs() throws RemoteStorageException, InterruptedException {
        TopicIdPartition topicIdPartition = new TopicIdPartition(Uuid.randomUuid(), new TopicPartition("singleton", 0));
        TopicBasedRemoteLogMetadataManager topicBasedRemoteLogMetadataManager = this.topicBasedRlmm();
        CountDownLatch initializationLatch = new CountDownLatch(1);
        ((RemotePartitionMetadataStore)Mockito.doAnswer(invocationOnMock -> {
            Object result = invocationOnMock.callRealMethod();
            initializationLatch.countDown();
            return result;
        }).when((Object)this.spyRemotePartitionMetadataEventHandler)).markInitialized((TopicIdPartition)ArgumentMatchers.any());
        CountDownLatch handleRemoteLogSegmentMetadataLatch = new CountDownLatch(3);
        ((RemotePartitionMetadataStore)Mockito.doAnswer(invocationOnMock -> {
            Object result = invocationOnMock.callRealMethod();
            handleRemoteLogSegmentMetadataLatch.countDown();
            return result;
        }).when((Object)this.spyRemotePartitionMetadataEventHandler)).handleRemoteLogSegmentMetadata((RemoteLogSegmentMetadata)ArgumentMatchers.any());
        RemoteLogSegmentMetadata firstSegmentMetadata = new RemoteLogSegmentMetadata(new RemoteLogSegmentId(topicIdPartition, Uuid.randomUuid()), 0L, 100L, -1L, 0, this.time.milliseconds(), 0x100000, Collections.singletonMap(0, 0L));
        RemoteLogSegmentMetadata secondSegmentMetadata = new RemoteLogSegmentMetadata(new RemoteLogSegmentId(topicIdPartition, Uuid.randomUuid()), 100L, 200L, -1L, 0, this.time.milliseconds(), 0x200000, Collections.singletonMap(1, 100L));
        RemoteLogSegmentMetadata thirdSegmentMetadata = new RemoteLogSegmentMetadata(new RemoteLogSegmentId(topicIdPartition, Uuid.randomUuid()), 200L, 300L, -1L, 0, this.time.milliseconds(), 0x300000, Collections.singletonMap(2, 200L));
        topicBasedRemoteLogMetadataManager.addRemoteLogSegmentMetadata(firstSegmentMetadata);
        topicBasedRemoteLogMetadataManager.addRemoteLogSegmentMetadata(secondSegmentMetadata);
        topicBasedRemoteLogMetadataManager.addRemoteLogSegmentMetadata(thirdSegmentMetadata);
        topicBasedRemoteLogMetadataManager.onPartitionLeadershipChanges(Collections.singleton(topicIdPartition), Collections.emptySet());
        Assertions.assertTrue((boolean)initializationLatch.await(30000L, TimeUnit.MILLISECONDS));
        Assertions.assertTrue((boolean)handleRemoteLogSegmentMetadataLatch.await(30000L, TimeUnit.MILLISECONDS));
        ((RemotePartitionMetadataStore)Mockito.verify((Object)this.spyRemotePartitionMetadataEventHandler)).markInitialized(topicIdPartition);
        ((RemotePartitionMetadataStore)Mockito.verify((Object)this.spyRemotePartitionMetadataEventHandler)).handleRemoteLogSegmentMetadata(firstSegmentMetadata);
        ((RemotePartitionMetadataStore)Mockito.verify((Object)this.spyRemotePartitionMetadataEventHandler)).handleRemoteLogSegmentMetadata(secondSegmentMetadata);
        ((RemotePartitionMetadataStore)Mockito.verify((Object)this.spyRemotePartitionMetadataEventHandler)).handleRemoteLogSegmentMetadata(thirdSegmentMetadata);
        Assertions.assertEquals((long)0x100000L, (long)topicBasedRemoteLogMetadataManager.remoteLogSize(topicIdPartition, 0));
        Assertions.assertEquals((long)0x200000L, (long)topicBasedRemoteLogMetadataManager.remoteLogSize(topicIdPartition, 1));
        Assertions.assertEquals((long)0x300000L, (long)topicBasedRemoteLogMetadataManager.remoteLogSize(topicIdPartition, 2));
    }

    @ClusterTest
    public void testRemoteLogSizeCalculationWithSegmentsHavingNonExistentEpochs() throws RemoteStorageException, InterruptedException {
        TopicIdPartition topicIdPartition = new TopicIdPartition(Uuid.randomUuid(), new TopicPartition("singleton", 0));
        TopicBasedRemoteLogMetadataManager topicBasedRemoteLogMetadataManager = this.topicBasedRlmm();
        CountDownLatch initializationLatch = new CountDownLatch(1);
        ((RemotePartitionMetadataStore)Mockito.doAnswer(invocationOnMock -> {
            Object result = invocationOnMock.callRealMethod();
            initializationLatch.countDown();
            return result;
        }).when((Object)this.spyRemotePartitionMetadataEventHandler)).markInitialized((TopicIdPartition)ArgumentMatchers.any());
        CountDownLatch handleRemoteLogSegmentMetadataLatch = new CountDownLatch(2);
        ((RemotePartitionMetadataStore)Mockito.doAnswer(invocationOnMock -> {
            Object result = invocationOnMock.callRealMethod();
            handleRemoteLogSegmentMetadataLatch.countDown();
            return result;
        }).when((Object)this.spyRemotePartitionMetadataEventHandler)).handleRemoteLogSegmentMetadata((RemoteLogSegmentMetadata)ArgumentMatchers.any());
        RemoteLogSegmentMetadata firstSegmentMetadata = new RemoteLogSegmentMetadata(new RemoteLogSegmentId(topicIdPartition, Uuid.randomUuid()), 0L, 100L, -1L, 0, this.time.milliseconds(), 0x100000, Collections.singletonMap(0, 0L));
        RemoteLogSegmentMetadata secondSegmentMetadata = new RemoteLogSegmentMetadata(new RemoteLogSegmentId(topicIdPartition, Uuid.randomUuid()), 100L, 200L, -1L, 0, this.time.milliseconds(), 0x200000, Collections.singletonMap(1, 100L));
        topicBasedRemoteLogMetadataManager.addRemoteLogSegmentMetadata(firstSegmentMetadata);
        topicBasedRemoteLogMetadataManager.addRemoteLogSegmentMetadata(secondSegmentMetadata);
        topicBasedRemoteLogMetadataManager.onPartitionLeadershipChanges(Collections.singleton(topicIdPartition), Collections.emptySet());
        Assertions.assertTrue((boolean)initializationLatch.await(30000L, TimeUnit.MILLISECONDS));
        Assertions.assertTrue((boolean)handleRemoteLogSegmentMetadataLatch.await(30000L, TimeUnit.MILLISECONDS));
        ((RemotePartitionMetadataStore)Mockito.verify((Object)this.spyRemotePartitionMetadataEventHandler)).markInitialized(topicIdPartition);
        ((RemotePartitionMetadataStore)Mockito.verify((Object)this.spyRemotePartitionMetadataEventHandler)).handleRemoteLogSegmentMetadata(firstSegmentMetadata);
        ((RemotePartitionMetadataStore)Mockito.verify((Object)this.spyRemotePartitionMetadataEventHandler)).handleRemoteLogSegmentMetadata(secondSegmentMetadata);
        Assertions.assertEquals((long)0L, (long)topicBasedRemoteLogMetadataManager.remoteLogSize(topicIdPartition, 9001));
    }
}

