/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.log.remote.metadata.storage;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import kafka.test.ClusterInstance;
import kafka.test.annotation.ClusterTest;
import kafka.test.junit.ClusterTestExtensions;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.utils.SystemTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.log.remote.metadata.storage.RemoteLogMetadataManagerTestUtils;
import org.apache.kafka.server.log.remote.metadata.storage.RemoteLogMetadataTopicPartitioner;
import org.apache.kafka.server.log.remote.metadata.storage.TopicBasedRemoteLogMetadataManager;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentId;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentMetadata;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ClusterTestExtensions.class})
@Tag(value="integration")
public class TopicBasedRemoteLogMetadataManagerRestartTest {
    private final Time time = new SystemTime();
    private final String logDir = TestUtils.tempDirectory((String)"_rlmm_segs_").getAbsolutePath();
    private final ClusterInstance clusterInstance;

    TopicBasedRemoteLogMetadataManagerRestartTest(ClusterInstance clusterInstance) {
        this.clusterInstance = clusterInstance;
    }

    private TopicBasedRemoteLogMetadataManager createTopicBasedRemoteLogMetadataManager() {
        return RemoteLogMetadataManagerTestUtils.builder().bootstrapServers(this.clusterInstance.bootstrapServers()).startConsumerThread(true).remoteLogMetadataTopicPartitioner(RemoteLogMetadataTopicPartitioner::new).overrideRemoteLogMetadataManagerProps(Collections.singletonMap("log.dir", this.logDir)).build();
    }

    @ClusterTest(brokers=3)
    public void testRLMMAPIsAfterRestart() throws Exception {
        String leaderTopic = "new-leader";
        String followerTopic = "new-follower";
        try (Admin admin = this.clusterInstance.createAdminClient();){
            NewTopic newLeaderTopic = new NewTopic(leaderTopic, Collections.singletonMap(0, Arrays.asList(0, 1, 2)));
            NewTopic newFollowerTopic = new NewTopic(followerTopic, Collections.singletonMap(0, Arrays.asList(1, 2, 0)));
            admin.createTopics(Arrays.asList(newLeaderTopic, newFollowerTopic)).all().get();
        }
        this.clusterInstance.waitForTopic(leaderTopic, 1);
        this.clusterInstance.waitForTopic(followerTopic, 1);
        TopicIdPartition leaderTopicIdPartition = new TopicIdPartition(Uuid.randomUuid(), new TopicPartition(leaderTopic, 0));
        TopicIdPartition followerTopicIdPartition = new TopicIdPartition(Uuid.randomUuid(), new TopicPartition(followerTopic, 0));
        int segSize = 0x100000;
        RemoteLogSegmentMetadata leaderSegmentMetadata = new RemoteLogSegmentMetadata(new RemoteLogSegmentId(leaderTopicIdPartition, Uuid.randomUuid()), 0L, 100L, -1L, 0, this.time.milliseconds(), segSize, Collections.singletonMap(0, 0L));
        RemoteLogSegmentMetadata followerSegmentMetadata = new RemoteLogSegmentMetadata(new RemoteLogSegmentId(followerTopicIdPartition, Uuid.randomUuid()), 0L, 100L, -1L, 0, this.time.milliseconds(), segSize, Collections.singletonMap(0, 0L));
        try (TopicBasedRemoteLogMetadataManager topicBasedRemoteLogMetadataManager = this.createTopicBasedRemoteLogMetadataManager();){
            topicBasedRemoteLogMetadataManager.onPartitionLeadershipChanges(Collections.singleton(leaderTopicIdPartition), Collections.singleton(followerTopicIdPartition));
            topicBasedRemoteLogMetadataManager.addRemoteLogSegmentMetadata(leaderSegmentMetadata).get();
            topicBasedRemoteLogMetadataManager.addRemoteLogSegmentMetadata(followerSegmentMetadata).get();
        }
        topicBasedRemoteLogMetadataManager = this.createTopicBasedRemoteLogMetadataManager();
        var9_14 = null;
        try {
            topicBasedRemoteLogMetadataManager.onPartitionLeadershipChanges(Collections.singleton(leaderTopicIdPartition), Collections.singleton(followerTopicIdPartition));
            TestUtils.waitForCondition(() -> TestUtils.sameElementsWithoutOrder(Collections.singleton(leaderSegmentMetadata).iterator(), (Iterator)topicBasedRemoteLogMetadataManager.listRemoteLogSegments(leaderTopicIdPartition)), (String)"Remote log segment metadata not available");
            TestUtils.waitForCondition(() -> TestUtils.sameElementsWithoutOrder(Collections.singleton(followerSegmentMetadata).iterator(), (Iterator)topicBasedRemoteLogMetadataManager.listRemoteLogSegments(followerTopicIdPartition)), (String)"Remote log segment metadata not available");
            RemoteLogSegmentMetadata leaderSegmentMetadata2 = new RemoteLogSegmentMetadata(new RemoteLogSegmentId(leaderTopicIdPartition, Uuid.randomUuid()), 101L, 200L, -1L, 0, this.time.milliseconds(), segSize, Collections.singletonMap(0, 101L));
            topicBasedRemoteLogMetadataManager.addRemoteLogSegmentMetadata(leaderSegmentMetadata2).get();
            Assertions.assertTrue((boolean)TestUtils.sameElementsWithoutOrder(Arrays.asList(leaderSegmentMetadata, leaderSegmentMetadata2).iterator(), (Iterator)topicBasedRemoteLogMetadataManager.listRemoteLogSegments(leaderTopicIdPartition)));
        }
        catch (Throwable throwable) {
            var9_14 = throwable;
            throw throwable;
        }
        finally {
            if (topicBasedRemoteLogMetadataManager != null) {
                if (var9_14 != null) {
                    try {
                        topicBasedRemoteLogMetadataManager.close();
                    }
                    catch (Throwable throwable) {
                        var9_14.addSuppressed(throwable);
                    }
                } else {
                    topicBasedRemoteLogMetadataManager.close();
                }
            }
        }
    }
}

