/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.log.remote.metadata.storage;

import java.util.HashMap;
import java.util.Optional;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.utils.SystemTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.log.remote.metadata.storage.serialization.RemoteLogMetadataSerde;
import org.apache.kafka.server.log.remote.storage.RemoteLogMetadata;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentId;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentMetadata;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentMetadataUpdate;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentState;
import org.apache.kafka.server.log.remote.storage.RemotePartitionDeleteMetadata;
import org.apache.kafka.server.log.remote.storage.RemotePartitionDeleteState;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RemoteLogMetadataSerdeTest {
    public static final String TOPIC = "foo";
    private static final TopicIdPartition TP0 = new TopicIdPartition(Uuid.randomUuid(), new TopicPartition("foo", 0));
    private final Time time = new SystemTime();

    @Test
    public void testRemoteLogSegmentMetadataSerde() {
        RemoteLogSegmentMetadata remoteLogSegmentMetadata = this.createRemoteLogSegmentMetadata();
        this.doTestRemoteLogMetadataSerde((RemoteLogMetadata)remoteLogSegmentMetadata);
    }

    @Test
    public void testRemoteLogSegmentMetadataUpdateSerde() {
        RemoteLogSegmentMetadataUpdate remoteLogSegmentMetadataUpdate = this.createRemoteLogSegmentMetadataUpdate();
        this.doTestRemoteLogMetadataSerde((RemoteLogMetadata)remoteLogSegmentMetadataUpdate);
    }

    @Test
    public void testRemotePartitionDeleteMetadataSerde() {
        RemotePartitionDeleteMetadata remotePartitionDeleteMetadata = this.createRemotePartitionDeleteMetadata();
        this.doTestRemoteLogMetadataSerde((RemoteLogMetadata)remotePartitionDeleteMetadata);
    }

    private RemoteLogSegmentMetadata createRemoteLogSegmentMetadata() {
        HashMap<Integer, Long> segLeaderEpochs = new HashMap<Integer, Long>();
        segLeaderEpochs.put(0, 0L);
        segLeaderEpochs.put(1, 20L);
        segLeaderEpochs.put(2, 80L);
        RemoteLogSegmentId remoteLogSegmentId = new RemoteLogSegmentId(TP0, Uuid.randomUuid());
        return new RemoteLogSegmentMetadata(remoteLogSegmentId, 0L, 100L, -1L, 1, this.time.milliseconds(), 1024, Optional.of(new RemoteLogSegmentMetadata.CustomMetadata(new byte[]{0, 1, 2, 3})), RemoteLogSegmentState.COPY_SEGMENT_STARTED, segLeaderEpochs);
    }

    private RemoteLogSegmentMetadataUpdate createRemoteLogSegmentMetadataUpdate() {
        RemoteLogSegmentId remoteLogSegmentId = new RemoteLogSegmentId(TP0, Uuid.randomUuid());
        return new RemoteLogSegmentMetadataUpdate(remoteLogSegmentId, this.time.milliseconds(), Optional.of(new RemoteLogSegmentMetadata.CustomMetadata(new byte[]{0, 1, 2, 3})), RemoteLogSegmentState.COPY_SEGMENT_FINISHED, 2);
    }

    private RemotePartitionDeleteMetadata createRemotePartitionDeleteMetadata() {
        return new RemotePartitionDeleteMetadata(TP0, RemotePartitionDeleteState.DELETE_PARTITION_MARKED, this.time.milliseconds(), 0);
    }

    private void doTestRemoteLogMetadataSerde(RemoteLogMetadata remoteLogMetadata) {
        RemoteLogMetadataSerde serializer = new RemoteLogMetadataSerde();
        byte[] metadataBytes = serializer.serialize(remoteLogMetadata);
        RemoteLogMetadataSerde deserializer = new RemoteLogMetadataSerde();
        RemoteLogMetadata deserializedRemoteLogMetadata = deserializer.deserialize(metadataBytes);
        Assertions.assertEquals((Object)remoteLogMetadata, (Object)deserializedRemoteLogMetadata);
    }

    @Test
    public void testInvalidRemoteStorageMetadata() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new RemoteLogMetadataSerde().serialize((RemoteLogMetadata)new InvalidRemoteLogMetadata(1, this.time.milliseconds())));
    }

    private static class InvalidRemoteLogMetadata
    extends RemoteLogMetadata {
        public InvalidRemoteLogMetadata(int brokerId, long eventTimestampMs) {
            super(brokerId, eventTimestampMs);
        }

        public TopicIdPartition topicIdPartition() {
            throw new UnsupportedOperationException();
        }
    }
}

