/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.log.remote.metadata.storage;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.kafka.server.log.remote.metadata.storage.RemoteLogMetadataTopicPartitioner;
import org.apache.kafka.server.log.remote.metadata.storage.RemotePartitionMetadataStore;
import org.apache.kafka.server.log.remote.metadata.storage.TopicBasedRemoteLogMetadataManager;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;

public class RemoteLogMetadataManagerTestUtils {
    private static final int METADATA_TOPIC_PARTITIONS_COUNT = 3;
    private static final short METADATA_TOPIC_REPLICATION_FACTOR = 2;
    private static final long METADATA_TOPIC_RETENTION_MS = 86400000L;

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String bootstrapServers;
        private boolean startConsumerThread;
        private Map<String, Object> overrideRemoteLogMetadataManagerProps = Collections.emptyMap();
        private Supplier<RemotePartitionMetadataStore> remotePartitionMetadataStore = RemotePartitionMetadataStore::new;
        private Function<Integer, RemoteLogMetadataTopicPartitioner> remoteLogMetadataTopicPartitioner = RemoteLogMetadataTopicPartitioner::new;

        private Builder() {
        }

        public Builder bootstrapServers(String bootstrapServers) {
            this.bootstrapServers = Objects.requireNonNull(bootstrapServers);
            return this;
        }

        public Builder startConsumerThread(boolean startConsumerThread) {
            this.startConsumerThread = startConsumerThread;
            return this;
        }

        public Builder remotePartitionMetadataStore(Supplier<RemotePartitionMetadataStore> remotePartitionMetadataStore) {
            this.remotePartitionMetadataStore = remotePartitionMetadataStore;
            return this;
        }

        public Builder remoteLogMetadataTopicPartitioner(Function<Integer, RemoteLogMetadataTopicPartitioner> remoteLogMetadataTopicPartitioner) {
            this.remoteLogMetadataTopicPartitioner = Objects.requireNonNull(remoteLogMetadataTopicPartitioner);
            return this;
        }

        public Builder overrideRemoteLogMetadataManagerProps(Map<String, Object> overrideRemoteLogMetadataManagerProps) {
            this.overrideRemoteLogMetadataManagerProps = Objects.requireNonNull(overrideRemoteLogMetadataManagerProps);
            return this;
        }

        public TopicBasedRemoteLogMetadataManager build() {
            Objects.requireNonNull(this.bootstrapServers);
            String logDir = TestUtils.tempDirectory((String)"rlmm_segs_").getAbsolutePath();
            TopicBasedRemoteLogMetadataManager topicBasedRemoteLogMetadataManager = new TopicBasedRemoteLogMetadataManager(this.startConsumerThread, this.remoteLogMetadataTopicPartitioner, this.remotePartitionMetadataStore);
            HashMap<String, Object> configs = new HashMap<String, Object>();
            configs.put("remote.log.metadata.common.client.bootstrap.servers", this.bootstrapServers);
            configs.put("broker.id", 0);
            configs.put("log.dir", logDir);
            configs.put("remote.log.metadata.topic.num.partitions", 3);
            configs.put("remote.log.metadata.topic.replication.factor", (short)2);
            configs.put("remote.log.metadata.topic.retention.ms", 86400000L);
            configs.putAll(this.overrideRemoteLogMetadataManagerProps);
            topicBasedRemoteLogMetadataManager.configure(configs);
            Assertions.assertDoesNotThrow(() -> TestUtils.waitForCondition(() -> ((TopicBasedRemoteLogMetadataManager)topicBasedRemoteLogMetadataManager).isInitialized(), (long)60000L, (String)"Time out reached before it is initialized successfully"));
            return topicBasedRemoteLogMetadataManager;
        }
    }
}

