/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.log.remote.metadata.storage;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.server.log.remote.metadata.storage.RemoteLogLeaderEpochState;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentId;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentMetadata;
import org.apache.kafka.server.log.remote.storage.RemoteResourceNotFoundException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class RemoteLogLeaderEpochStateTest {
    TopicPartition tp = new TopicPartition("topic", 0);
    TopicIdPartition tpId = new TopicIdPartition(Uuid.randomUuid(), this.tp);
    RemoteLogLeaderEpochState epochState = new RemoteLogLeaderEpochState();

    RemoteLogLeaderEpochStateTest() {
    }

    @Test
    void testListAllRemoteLogSegmentsOnEmpty() throws RemoteResourceNotFoundException {
        Assertions.assertFalse((boolean)this.epochState.listAllRemoteLogSegments(Collections.emptyMap()).hasNext());
    }

    @Test
    void testListAllRemoteLogSegmentsShouldThrowErrorForUnknownSegmentId() {
        RemoteLogSegmentId segmentId1 = new RemoteLogSegmentId(this.tpId, Uuid.randomUuid());
        RemoteLogSegmentId segmentId2 = new RemoteLogSegmentId(this.tpId, Uuid.randomUuid());
        this.epochState.handleSegmentWithCopySegmentFinishedState(Long.valueOf(0L), segmentId1, Long.valueOf(10L));
        Assertions.assertThrows(RemoteResourceNotFoundException.class, () -> this.epochState.listAllRemoteLogSegments(Collections.singletonMap(segmentId2, null)));
    }

    @Test
    void testListAllRemoteLogSegmentsShouldReturnSortedSegments() throws RemoteResourceNotFoundException {
        HashMap<RemoteLogSegmentId, RemoteLogSegmentMetadata> segmentIdToMetadataMap = new HashMap<RemoteLogSegmentId, RemoteLogSegmentMetadata>();
        RemoteLogSegmentId segmentId1 = new RemoteLogSegmentId(this.tpId, Uuid.randomUuid());
        this.epochState.handleSegmentWithCopySegmentStartedState(segmentId1);
        segmentIdToMetadataMap.put(segmentId1, this.createRemoteLogSegmentMetadata(segmentId1, 0L));
        RemoteLogSegmentId segmentId2 = new RemoteLogSegmentId(this.tpId, Uuid.randomUuid());
        this.epochState.handleSegmentWithCopySegmentFinishedState(Long.valueOf(5L), segmentId2, Long.valueOf(10L));
        segmentIdToMetadataMap.put(segmentId2, this.createRemoteLogSegmentMetadata(segmentId2, 5L));
        RemoteLogSegmentId segmentId3 = new RemoteLogSegmentId(this.tpId, Uuid.randomUuid());
        this.epochState.handleSegmentWithCopySegmentFinishedState(Long.valueOf(11L), segmentId3, Long.valueOf(100L));
        segmentIdToMetadataMap.put(segmentId3, this.createRemoteLogSegmentMetadata(segmentId3, 11L));
        RemoteLogSegmentId segmentId4 = new RemoteLogSegmentId(this.tpId, Uuid.randomUuid());
        this.epochState.handleSegmentWithCopySegmentFinishedState(Long.valueOf(9L), segmentId4, Long.valueOf(150L));
        segmentIdToMetadataMap.put(segmentId4, this.createRemoteLogSegmentMetadata(segmentId4, 9L));
        List<RemoteLogSegmentId> expectedList = Arrays.asList(segmentId1, segmentId2, segmentId4, segmentId3);
        ArrayList actualList = new ArrayList();
        this.epochState.listAllRemoteLogSegments(segmentIdToMetadataMap).forEachRemaining(metadata -> actualList.add(metadata.remoteLogSegmentId()));
        Assertions.assertEquals(expectedList, actualList);
    }

    @Test
    void handleSegmentWithCopySegmentStartedState() {
        RemoteLogSegmentId segmentId = new RemoteLogSegmentId(this.tpId, Uuid.randomUuid());
        this.epochState.handleSegmentWithCopySegmentStartedState(segmentId);
        Assertions.assertEquals((int)1, (int)this.epochState.unreferencedSegmentIds().size());
        Assertions.assertTrue((boolean)this.epochState.unreferencedSegmentIds().contains(segmentId));
    }

    @Test
    void handleSegmentWithCopySegmentFinishedState() {
        RemoteLogSegmentId segmentId1 = new RemoteLogSegmentId(this.tpId, Uuid.randomUuid());
        RemoteLogSegmentId segmentId2 = new RemoteLogSegmentId(this.tpId, Uuid.randomUuid());
        this.epochState.handleSegmentWithCopySegmentFinishedState(Long.valueOf(10L), segmentId1, Long.valueOf(100L));
        this.epochState.handleSegmentWithCopySegmentFinishedState(Long.valueOf(101L), segmentId2, Long.valueOf(200L));
        Assertions.assertEquals((int)2, (int)this.epochState.referencedSegmentIds().size());
        Assertions.assertEquals((Object)segmentId1, (Object)this.epochState.floorEntry(90L));
        Assertions.assertEquals((Object)segmentId2, (Object)this.epochState.floorEntry(150L));
        Assertions.assertTrue((boolean)this.epochState.unreferencedSegmentIds().isEmpty());
        Assertions.assertEquals((long)200L, (Long)this.epochState.highestLogOffset());
    }

    @Test
    void handleSegmentWithCopySegmentFinishedStateForOverlappingSegments() {
        RemoteLogSegmentId segmentId1 = new RemoteLogSegmentId(this.tpId, Uuid.randomUuid());
        RemoteLogSegmentId segmentId2 = new RemoteLogSegmentId(this.tpId, Uuid.randomUuid());
        this.epochState.handleSegmentWithCopySegmentFinishedState(Long.valueOf(10L), segmentId1, Long.valueOf(100L));
        this.epochState.handleSegmentWithCopySegmentFinishedState(Long.valueOf(5L), segmentId2, Long.valueOf(150L));
        Assertions.assertEquals((int)1, (int)this.epochState.referencedSegmentIds().size());
        Assertions.assertEquals((Object)segmentId2, (Object)this.epochState.floorEntry(11L));
        Assertions.assertEquals((int)1, (int)this.epochState.unreferencedSegmentIds().size());
        Assertions.assertTrue((boolean)this.epochState.unreferencedSegmentIds().contains(segmentId1));
        Assertions.assertEquals((long)150L, (Long)this.epochState.highestLogOffset());
    }

    @Test
    void handleSegmentWithCopySegmentFinishedStateForMultipleOverlappingSegments() {
        RemoteLogSegmentId segmentId1 = new RemoteLogSegmentId(this.tpId, Uuid.randomUuid());
        RemoteLogSegmentId segmentId2 = new RemoteLogSegmentId(this.tpId, Uuid.randomUuid());
        RemoteLogSegmentId segmentId3 = new RemoteLogSegmentId(this.tpId, Uuid.randomUuid());
        RemoteLogSegmentId segmentId4 = new RemoteLogSegmentId(this.tpId, Uuid.randomUuid());
        this.epochState.handleSegmentWithCopySegmentFinishedState(Long.valueOf(10L), segmentId1, Long.valueOf(100L));
        this.epochState.handleSegmentWithCopySegmentFinishedState(Long.valueOf(5L), segmentId2, Long.valueOf(150L));
        this.epochState.handleSegmentWithCopySegmentFinishedState(Long.valueOf(148L), segmentId3, Long.valueOf(155L));
        this.epochState.handleSegmentWithCopySegmentFinishedState(Long.valueOf(4L), segmentId4, Long.valueOf(200L));
        Assertions.assertEquals((int)1, (int)this.epochState.referencedSegmentIds().size());
        Assertions.assertEquals((Object)segmentId4, (Object)this.epochState.floorEntry(11L));
        Assertions.assertEquals((int)3, (int)this.epochState.unreferencedSegmentIds().size());
        Assertions.assertTrue((boolean)this.epochState.unreferencedSegmentIds().containsAll(Arrays.asList(segmentId1, segmentId2, segmentId3)));
        Assertions.assertEquals((long)200L, (Long)this.epochState.highestLogOffset());
    }

    @Test
    void handleSegmentWithCopySegmentFinishedStateForDuplicateSegments() {
        RemoteLogSegmentId segmentId1 = new RemoteLogSegmentId(this.tpId, Uuid.randomUuid());
        RemoteLogSegmentId segmentId2 = new RemoteLogSegmentId(this.tpId, Uuid.randomUuid());
        this.epochState.handleSegmentWithCopySegmentFinishedState(Long.valueOf(10L), segmentId1, Long.valueOf(100L));
        this.epochState.handleSegmentWithCopySegmentFinishedState(Long.valueOf(10L), segmentId2, Long.valueOf(100L));
        Assertions.assertEquals((Object)segmentId2, (Object)this.epochState.floorEntry(11L));
        Assertions.assertEquals((int)1, (int)this.epochState.unreferencedSegmentIds().size());
        Assertions.assertTrue((boolean)this.epochState.unreferencedSegmentIds().contains(segmentId1));
        Assertions.assertEquals((long)100L, (Long)this.epochState.highestLogOffset());
    }

    @Test
    void handleSegmentWithCopySegmentFinishedStateForSegmentsWithSameStartOffset() {
        RemoteLogSegmentId segmentId1 = new RemoteLogSegmentId(this.tpId, Uuid.randomUuid());
        RemoteLogSegmentId segmentId2 = new RemoteLogSegmentId(this.tpId, Uuid.randomUuid());
        this.epochState.handleSegmentWithCopySegmentFinishedState(Long.valueOf(10L), segmentId1, Long.valueOf(100L));
        this.epochState.handleSegmentWithCopySegmentFinishedState(Long.valueOf(10L), segmentId2, Long.valueOf(150L));
        Assertions.assertEquals((Object)segmentId2, (Object)this.epochState.floorEntry(11L));
        Assertions.assertEquals((Object)segmentId2, (Object)this.epochState.floorEntry(111L));
        Assertions.assertEquals((int)1, (int)this.epochState.unreferencedSegmentIds().size());
        Assertions.assertEquals((long)150L, (Long)this.epochState.highestLogOffset());
    }

    @Test
    void handleSegmentWithDeleteSegmentStartedState() {
        RemoteLogSegmentId segmentId1 = new RemoteLogSegmentId(this.tpId, Uuid.randomUuid());
        RemoteLogSegmentId segmentId2 = new RemoteLogSegmentId(this.tpId, Uuid.randomUuid());
        this.epochState.handleSegmentWithCopySegmentFinishedState(Long.valueOf(10L), segmentId1, Long.valueOf(100L));
        this.epochState.handleSegmentWithCopySegmentFinishedState(Long.valueOf(101L), segmentId2, Long.valueOf(200L));
        Assertions.assertEquals((int)2, (int)this.epochState.referencedSegmentIds().size());
        this.epochState.handleSegmentWithDeleteSegmentStartedState(Long.valueOf(10L), segmentId1);
        this.epochState.handleSegmentWithDeleteSegmentStartedState(Long.valueOf(101L), segmentId2);
        Assertions.assertTrue((boolean)this.epochState.referencedSegmentIds().isEmpty());
        Assertions.assertEquals((int)2, (int)this.epochState.unreferencedSegmentIds().size());
        Assertions.assertTrue((boolean)this.epochState.unreferencedSegmentIds().containsAll(Arrays.asList(segmentId1, segmentId2)));
    }

    @Test
    void handleSegmentWithDeleteSegmentFinishedState() {
        RemoteLogSegmentId segmentId = new RemoteLogSegmentId(this.tpId, Uuid.randomUuid());
        this.epochState.handleSegmentWithCopySegmentStartedState(segmentId);
        Assertions.assertEquals((int)1, (int)this.epochState.unreferencedSegmentIds().size());
        this.epochState.handleSegmentWithDeleteSegmentFinishedState(segmentId);
        Assertions.assertTrue((boolean)this.epochState.unreferencedSegmentIds().isEmpty());
    }

    private RemoteLogSegmentMetadata createRemoteLogSegmentMetadata(RemoteLogSegmentId remoteLogSegmentId, long startOffset) {
        RemoteLogSegmentMetadata metadata = (RemoteLogSegmentMetadata)Mockito.mock(RemoteLogSegmentMetadata.class);
        Mockito.when((Object)metadata.remoteLogSegmentId()).thenReturn((Object)remoteLogSegmentId);
        Mockito.when((Object)metadata.startOffset()).thenReturn((Object)startOffset);
        return metadata;
    }
}

