/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tiered.storage.utils;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kafka.server.KafkaConfig;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.server.log.remote.metadata.storage.TopicBasedRemoteLogMetadataManager;
import org.apache.kafka.server.log.remote.storage.LocalTieredStorage;
import org.apache.kafka.tiered.storage.TieredStorageTestContext;
import org.junit.jupiter.api.Assertions;

public class TieredStorageTestUtils {
    public static final Integer STORAGE_WAIT_TIMEOUT_SEC = 35;
    private static final Integer LOG_CLEANUP_INTERVAL_MS = 500;
    private static final Integer RLM_TASK_INTERVAL_MS = 500;
    private static final Integer RLMM_INIT_RETRY_INTERVAL_MS = 300;

    public static TopicDescription describeTopic(TieredStorageTestContext context, String topic) throws ExecutionException, InterruptedException {
        return TieredStorageTestUtils.describeTopics(context, Collections.singletonList(topic)).get(topic);
    }

    public static Map<String, TopicDescription> describeTopics(TieredStorageTestContext context, List<String> topics) throws ExecutionException, InterruptedException {
        return (Map)context.admin().describeTopics(topics).allTopicNames().get();
    }

    public static List<Record> tieredStorageRecords(TieredStorageTestContext context, TopicPartition topicPartition) {
        return context.takeTieredStorageSnapshot().getFilesets(topicPartition).stream().map(fileset -> {
            try {
                return fileset.getRecords();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }).sorted(Comparator.comparingLong(records -> ((Record)records.get(0)).offset())).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public static Properties createPropsForRemoteStorage(String testClassName, String storageDirPath, int brokerCount, int numRemoteLogMetadataPartitions, Properties overridingProps) {
        Assertions.assertTrue(((long)STORAGE_WAIT_TIMEOUT_SEC.intValue() > TimeUnit.MILLISECONDS.toSeconds(RLM_TASK_INTERVAL_MS.intValue()) ? 1 : 0) != 0, (String)"STORAGE_WAIT_TIMEOUT_SEC should be greater than RLM_TASK_INTERVAL_MS");
        overridingProps.setProperty("remote.log.storage.system.enable", "true");
        overridingProps.setProperty("remote.log.storage.manager.class.name", LocalTieredStorage.class.getName());
        overridingProps.setProperty("remote.log.metadata.manager.class.name", TopicBasedRemoteLogMetadataManager.class.getName());
        overridingProps.setProperty("remote.log.manager.task.interval.ms", RLM_TASK_INTERVAL_MS.toString());
        overridingProps.setProperty("remote.log.metadata.manager.listener.name", "PLAINTEXT");
        overridingProps.setProperty("remote.log.storage.manager.impl.prefix", TieredStorageTestUtils.storageConfigPrefix(testClassName, ""));
        overridingProps.setProperty("remote.log.metadata.manager.impl.prefix", TieredStorageTestUtils.metadataConfigPrefix(testClassName, ""));
        overridingProps.setProperty(TieredStorageTestUtils.metadataConfigPrefix(testClassName, "remote.log.metadata.topic.num.partitions"), String.valueOf(numRemoteLogMetadataPartitions));
        overridingProps.setProperty(TieredStorageTestUtils.metadataConfigPrefix(testClassName, "remote.log.metadata.topic.replication.factor"), String.valueOf(brokerCount));
        overridingProps.setProperty(KafkaConfig.LogCleanupIntervalMsProp(), LOG_CLEANUP_INTERVAL_MS.toString());
        overridingProps.setProperty(TieredStorageTestUtils.storageConfigPrefix(testClassName, "dir"), storageDirPath);
        overridingProps.setProperty(TieredStorageTestUtils.storageConfigPrefix(testClassName, "delete.on.close"), "false");
        overridingProps.setProperty(TieredStorageTestUtils.metadataConfigPrefix(testClassName, "remote.log.metadata.initialization.retry.interval.ms"), RLMM_INIT_RETRY_INTERVAL_MS.toString());
        return overridingProps;
    }

    public static Map<String, String> createTopicConfigForRemoteStorage(boolean enableRemoteStorage, int maxRecordBatchPerSegment) {
        HashMap<String, String> topicProps = new HashMap<String, String>();
        topicProps.put("remote.storage.enable", String.valueOf(enableRemoteStorage));
        topicProps.put("index.interval.bytes", "1");
        topicProps.put("segment.index.bytes", String.valueOf(12 * maxRecordBatchPerSegment));
        topicProps.put("local.retention.bytes", "1");
        return topicProps;
    }

    private static String storageConfigPrefix(String testClassName, String key) {
        return "rsm.config." + testClassName + "." + key;
    }

    private static String metadataConfigPrefix(String testClassName, String key) {
        return "rlmm.config." + testClassName + "." + key;
    }
}

