/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tiered.storage.utils;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.FileLogInputStream;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Timer;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.storage.internals.log.LogFileUtils;

public final class BrokerLocalStorage {
    private final Integer brokerId;
    private final File brokerStorageDirectory;
    private final Integer storageWaitTimeoutSec;
    private final int storagePollPeriodSec = 1;
    private final Time time = Time.SYSTEM;

    public BrokerLocalStorage(Integer brokerId, String storageDirname, Integer storageWaitTimeoutSec) {
        this.brokerId = brokerId;
        this.brokerStorageDirectory = new File(storageDirname);
        this.storageWaitTimeoutSec = storageWaitTimeoutSec;
    }

    public Integer getBrokerId() {
        return this.brokerId;
    }

    public void waitForEarliestLocalOffset(TopicPartition topicPartition, Long offset) {
        Function<OffsetHolder, Optional<String>> relativePosFunc = offsetHolder -> {
            Optional<Object> result = Optional.empty();
            if (((OffsetHolder)offsetHolder).firstLogFileBaseOffset < offset && !this.isOffsetPresentInFirstLocalSegment(topicPartition, ((OffsetHolder)offsetHolder).firstLogFileBaseOffset, offset)) {
                result = Optional.of("smaller than");
            } else if (((OffsetHolder)offsetHolder).firstLogFileBaseOffset > offset) {
                result = Optional.of("ahead of");
            }
            return result;
        };
        this.waitForOffset(topicPartition, offset, relativePosFunc);
    }

    public void waitForAtLeastEarliestLocalOffset(TopicPartition topicPartition, Long offset) {
        Function<OffsetHolder, Optional<String>> relativePosFunc = offsetHolder -> {
            Optional<Object> result = Optional.empty();
            if (((OffsetHolder)offsetHolder).firstLogFileBaseOffset < offset && !this.isOffsetPresentInFirstLocalSegment(topicPartition, ((OffsetHolder)offsetHolder).firstLogFileBaseOffset, offset)) {
                result = Optional.of("smaller than");
            }
            return result;
        };
        this.waitForOffset(topicPartition, offset, relativePosFunc);
    }

    private void waitForOffset(TopicPartition topicPartition, Long offset, Function<OffsetHolder, Optional<String>> relativePosFunc) {
        Timer timer = this.time.timer(TimeUnit.SECONDS.toMillis(this.storageWaitTimeoutSec.intValue()));
        OffsetHolder offsetHolder = new OffsetHolder(0L, Collections.emptyList());
        while (timer.notExpired() && offsetHolder.firstLogFileBaseOffset < offset) {
            timer.sleep(TimeUnit.SECONDS.toMillis(1L));
            offsetHolder = this.getEarliestLocalOffset(topicPartition);
        }
        Optional<String> relativePos = relativePosFunc.apply(offsetHolder);
        if (relativePos.isPresent()) {
            String pos = relativePos.get();
            String message = String.format("[BrokerId=%d] The base offset of the first log segment of %s in the log directory is %d which is %s the expected offset %s. The directory of %s is made of the following files: %s", this.brokerId, topicPartition, offsetHolder.firstLogFileBaseOffset, pos, offset, topicPartition, Utils.join((Collection)offsetHolder.partitionFiles, (String)System.lineSeparator()));
            throw new AssertionError((Object)message);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isOffsetPresentInFirstLocalSegment(TopicPartition topicPartition, Long firstLogFileBaseOffset, Long offsetToSearch) {
        if (offsetToSearch < firstLogFileBaseOffset) {
            return false;
        }
        if (offsetToSearch.equals(firstLogFileBaseOffset)) {
            return true;
        }
        File partitionDir = new File(this.brokerStorageDirectory.getAbsolutePath(), topicPartition.toString());
        File firstSegmentFile = new File(partitionDir.getAbsolutePath(), LogFileUtils.filenamePrefixFromOffset((long)firstLogFileBaseOffset) + ".log");
        try (FileRecords fileRecords = FileRecords.open((File)firstSegmentFile, (boolean)false);){
            FileLogInputStream.FileChannelRecordBatch batch;
            Iterator iterator = fileRecords.batches().iterator();
            do {
                if (!iterator.hasNext()) return false;
            } while ((batch = (FileLogInputStream.FileChannelRecordBatch)iterator.next()).baseOffset() > offsetToSearch || batch.lastOffset() < offsetToSearch);
            boolean bl = true;
            return bl;
        }
        catch (IOException ex) {
            return false;
        }
    }

    public void eraseStorage() throws IOException {
        for (File file : Objects.requireNonNull(this.brokerStorageDirectory.listFiles())) {
            Utils.delete((File)file);
        }
    }

    private OffsetHolder getEarliestLocalOffset(TopicPartition topicPartition) {
        List<String> partitionFiles = this.getTopicPartitionFiles(topicPartition);
        Optional<String> firstLogFile = partitionFiles.stream().filter(filename -> filename.endsWith(".log")).sorted().findFirst();
        if (!firstLogFile.isPresent()) {
            throw new IllegalArgumentException(String.format("[BrokerId=%d] No log file found for the topic-partition %s", this.brokerId, topicPartition));
        }
        return new OffsetHolder(LogFileUtils.offsetFromFileName((String)firstLogFile.get()), partitionFiles);
    }

    private List<String> getTopicPartitionFiles(TopicPartition topicPartition) {
        File[] files = this.brokerStorageDirectory.listFiles((dir, name) -> name.equals(topicPartition.toString()));
        if (files == null || files.length == 0) {
            throw new IllegalArgumentException(String.format("[BrokerId=%d] Directory for the topic-partition %s was not found", this.brokerId, topicPartition));
        }
        File topicPartitionDir = files[0];
        return Arrays.stream((Object[])Objects.requireNonNull(topicPartitionDir.listFiles())).map(File::getName).collect(Collectors.toList());
    }

    private static final class OffsetHolder {
        private final long firstLogFileBaseOffset;
        private final List<String> partitionFiles;

        public OffsetHolder(long firstLogFileBaseOffset, List<String> partitionFiles) {
            this.firstLogFileBaseOffset = firstLogFileBaseOffset;
            this.partitionFiles = partitionFiles;
        }
    }
}

