/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tiered.storage.specs;

import java.util.List;
import java.util.Objects;
import org.apache.kafka.clients.producer.ProducerRecord;

public final class OffloadableSpec {
    private final Integer sourceBrokerId;
    private final Integer baseOffset;
    private final List<ProducerRecord<String, String>> records;

    public OffloadableSpec(Integer sourceBrokerId, Integer baseOffset, List<ProducerRecord<String, String>> records) {
        this.sourceBrokerId = sourceBrokerId;
        this.baseOffset = baseOffset;
        this.records = records;
    }

    public Integer getSourceBrokerId() {
        return this.sourceBrokerId;
    }

    public Integer getBaseOffset() {
        return this.baseOffset;
    }

    public List<ProducerRecord<String, String>> getRecords() {
        return this.records;
    }

    public String toString() {
        return "OffloadableSpec{sourceBrokerId=" + this.sourceBrokerId + ", baseOffset=" + this.baseOffset + ", records=" + this.records + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OffloadableSpec that = (OffloadableSpec)o;
        return Objects.equals(this.sourceBrokerId, that.sourceBrokerId) && Objects.equals(this.baseOffset, that.baseOffset) && Objects.equals(this.records, that.records);
    }

    public int hashCode() {
        return Objects.hash(this.sourceBrokerId, this.baseOffset, this.records);
    }
}

