/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tiered.storage.integration;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.server.log.remote.storage.LocalTieredStorageEvent;
import org.apache.kafka.tiered.storage.TieredStorageTestBuilder;
import org.apache.kafka.tiered.storage.TieredStorageTestHarness;
import org.apache.kafka.tiered.storage.specs.KeyValueSpec;

public abstract class BaseDeleteSegmentsTest
extends TieredStorageTestHarness {
    public int brokerCount() {
        return 1;
    }

    @Override
    protected void writeTestSpecifications(TieredStorageTestBuilder builder) {
        Integer broker0 = 0;
        String topicA = "topicA";
        Integer p0 = 0;
        Integer partitionCount = 1;
        Integer replicationFactor = 1;
        Integer maxBatchCountPerSegment = 1;
        Map<Integer, List<Integer>> replicaAssignment = null;
        boolean enableRemoteLogStorage = true;
        boolean beginEpoch = false;
        long startOffset = 3L;
        builder.createTopic("topicA", partitionCount, replicationFactor, maxBatchCountPerSegment, replicaAssignment, true).expectSegmentToBeOffloaded(broker0, "topicA", p0, 0, new KeyValueSpec("k0", "v0")).expectSegmentToBeOffloaded(broker0, "topicA", p0, 1, new KeyValueSpec("k1", "v1")).expectSegmentToBeOffloaded(broker0, "topicA", p0, 2, new KeyValueSpec("k2", "v2")).expectEarliestLocalOffsetInLogDirectory("topicA", p0, 3L).produceWithTimestamp("topicA", p0, new KeyValueSpec("k0", "v0"), new KeyValueSpec("k1", "v1"), new KeyValueSpec("k2", "v2"), new KeyValueSpec("k3", "v3", System.currentTimeMillis() + TimeUnit.DAYS.toMillis(1L))).updateTopicConfig("topicA", this.configsToBeAdded(), Collections.emptyList()).expectDeletionInRemoteStorage(broker0, "topicA", p0, LocalTieredStorageEvent.EventType.DELETE_SEGMENT, 3).waitForRemoteLogSegmentDeletion("topicA").expectLeaderEpochCheckpoint(broker0, "topicA", p0, 0, 3L).expectFetchFromTieredStorage(broker0, "topicA", p0, 0).consume("topicA", p0, 0L, 1, 0);
    }

    protected abstract Map<String, String> configsToBeAdded();
}

