/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tiered.storage;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.server.log.remote.storage.LocalTieredStorage;
import org.apache.kafka.tiered.storage.TieredStorageTestAction;
import org.apache.kafka.tiered.storage.TieredStorageTestContext;
import org.apache.kafka.tiered.storage.utils.DumpLocalTieredStorage;

public final class TieredStorageTestReport {
    private final TieredStorageTestContext context;
    private final List<TieredStorageTestAction> successfulActions = new ArrayList<TieredStorageTestAction>();
    private final List<TieredStorageTestAction> failedActions = new ArrayList<TieredStorageTestAction>();

    public TieredStorageTestReport(TieredStorageTestContext context) {
        this.context = context;
    }

    public synchronized void addSucceeded(TieredStorageTestAction action) {
        this.successfulActions.add(action);
    }

    public synchronized void addFailed(TieredStorageTestAction action) {
        this.failedActions.add(action);
    }

    public void print(PrintStream output) {
        output.println();
        int seqNo = 0;
        ArrayList<List<TieredStorageTestAction>> actionsLists = new ArrayList<List<TieredStorageTestAction>>();
        actionsLists.add(this.successfulActions);
        actionsLists.add(this.failedActions);
        ArrayList<String> statusList = new ArrayList<String>();
        statusList.add("SUCCESS");
        statusList.add("FAILURE");
        for (int i = 0; i < actionsLists.size(); ++i) {
            List actions = (List)actionsLists.get(i);
            String ident = (String)statusList.get(i);
            for (TieredStorageTestAction action : actions) {
                output.print("[" + ident + "] (" + ++seqNo + ") ");
                action.describe(output);
                output.println();
            }
        }
        String lts = "";
        if (!this.context.remoteStorageManagers().isEmpty()) {
            LocalTieredStorage tieredStorage = this.context.remoteStorageManagers().get(0);
            lts = DumpLocalTieredStorage.dump(tieredStorage, this.context.de(), this.context.de());
        }
        output.printf("Content of local tiered storage:%n%n%s%n", lts);
    }
}

