/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.storage.internals.checkpoint;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.OptionalLong;
import org.apache.kafka.storage.internals.checkpoint.CleanShutdownFileHandler;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=10L)
class CleanShutdownFileHandlerTest {
    CleanShutdownFileHandlerTest() {
    }

    @Test
    public void testCleanShutdownFileBasic() {
        File logDir = (File)Assertions.assertDoesNotThrow(() -> Files.createTempDirectory("kafka-cleanShutdownFile", new FileAttribute[0]).toFile());
        CleanShutdownFileHandler cleanShutdownFileHandler = new CleanShutdownFileHandler(logDir.getPath());
        Assertions.assertDoesNotThrow(() -> cleanShutdownFileHandler.write(10L));
        Assertions.assertTrue((boolean)cleanShutdownFileHandler.exists());
        Assertions.assertEquals((Object)OptionalLong.of(10L), (Object)cleanShutdownFileHandler.read());
        Assertions.assertDoesNotThrow(() -> cleanShutdownFileHandler.delete());
        Assertions.assertFalse((boolean)cleanShutdownFileHandler.exists());
    }

    @Test
    public void testCleanShutdownFileNonExist() {
        File logDir = (File)Assertions.assertDoesNotThrow(() -> Files.createTempDirectory("kafka-cleanShutdownFile", new FileAttribute[0]).toFile());
        CleanShutdownFileHandler cleanShutdownFileHandler = new CleanShutdownFileHandler(logDir.getPath());
        Assertions.assertDoesNotThrow(() -> cleanShutdownFileHandler.write(10L, 0));
        Assertions.assertTrue((boolean)cleanShutdownFileHandler.exists());
        Assertions.assertDoesNotThrow(() -> cleanShutdownFileHandler.delete());
        Assertions.assertFalse((boolean)cleanShutdownFileHandler.exists());
        Assertions.assertEquals((Object)OptionalLong.empty(), (Object)cleanShutdownFileHandler.read());
    }

    @Test
    public void testCleanShutdownFileCanParseWithUnknownFields() throws IOException {
        File logDir = (File)Assertions.assertDoesNotThrow(() -> Files.createTempDirectory("kafka-cleanShutdownFile", new FileAttribute[0]).toFile());
        CleanShutdownFileHandler cleanShutdownFileHandler = new CleanShutdownFileHandler(logDir.getPath());
        FileOutputStream os = new FileOutputStream(cleanShutdownFileHandler.cleanShutdownFile);
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)os, StandardCharsets.UTF_8));
        bw.write("{\"version\":0,\"brokerEpoch\":10,\"unknown\":123}");
        bw.flush();
        os.getFD().sync();
        Assertions.assertTrue((boolean)cleanShutdownFileHandler.exists());
        Assertions.assertEquals((Object)OptionalLong.of(10L), (Object)cleanShutdownFileHandler.read());
        Assertions.assertDoesNotThrow(() -> cleanShutdownFileHandler.delete());
        Assertions.assertFalse((boolean)cleanShutdownFileHandler.exists());
    }
}

