/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.log.remote.storage;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.server.log.remote.storage.LocalTieredStorageTraverser;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentFileset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RemoteTopicPartitionDirectory {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteTopicPartitionDirectory.class);
    private static final String UUID_LEGAL_CHARS = "[a-zA-Z0-9_-]{22}";
    private static final Pattern FILENAME_FORMAT = Pattern.compile("([a-zA-Z0-9._-]+)-(\\d+)-([a-zA-Z0-9_-]{22})");
    static final int GROUP_TOPIC = 1;
    static final int GROUP_PARTITION = 2;
    static final int GROUP_UUID = 3;
    private final File directory;
    private final boolean existed;
    private final TopicIdPartition topicIdPartition;

    RemoteTopicPartitionDirectory(TopicIdPartition topicIdPartition, File directory, boolean existed) {
        this.topicIdPartition = Objects.requireNonNull(topicIdPartition);
        this.directory = Objects.requireNonNull(directory);
        this.existed = existed;
    }

    public TopicIdPartition getTopicIdPartition() {
        return this.topicIdPartition;
    }

    boolean didExist() {
        return this.existed;
    }

    public File getDirectory() {
        return this.directory;
    }

    boolean delete() {
        return RemoteLogSegmentFileset.deleteFilesOnly(Arrays.asList(this.directory.listFiles())) && RemoteLogSegmentFileset.deleteQuietly(this.directory);
    }

    void traverse(LocalTieredStorageTraverser traverser) {
        traverser.visitTopicIdPartition(this.topicIdPartition);
        this.listFilesets().stream().forEach(fileset -> traverser.visitSegment((RemoteLogSegmentFileset)fileset));
    }

    private List<RemoteLogSegmentFileset> listFilesets() {
        Set uuids = Arrays.stream(this.directory.listFiles()).map(file -> RemoteLogSegmentFileset.RemoteLogSegmentFileType.getUuid(file.getName())).collect(Collectors.toSet());
        return uuids.stream().map(uuid -> RemoteLogSegmentFileset.openExistingFileset(this, uuid)).collect(Collectors.toList());
    }

    public static RemoteTopicPartitionDirectory openTopicPartitionDirectory(TopicIdPartition topicIdPartition, File storageDirectory) {
        File directory = new File(storageDirectory, RemoteTopicPartitionDirectory.toString(topicIdPartition));
        boolean existed = directory.exists();
        if (!existed) {
            LOGGER.info("Creating directory: " + directory.getAbsolutePath());
            directory.mkdirs();
        }
        return new RemoteTopicPartitionDirectory(topicIdPartition, directory, existed);
    }

    public static RemoteTopicPartitionDirectory openExistingTopicPartitionDirectory(String dirname, File storageDirectory) {
        int partition;
        Uuid uuid = Uuid.fromString((String)RemoteTopicPartitionDirectory.substr(dirname, 3));
        String topic = RemoteTopicPartitionDirectory.substr(dirname, 1);
        try {
            partition = Integer.parseInt(RemoteTopicPartitionDirectory.substr(dirname, 2));
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException(String.format("Invalid format for topic-partition directory: %s", dirname), ex);
        }
        TopicPartition tp = new TopicPartition(topic, partition);
        TopicIdPartition idPartition = new TopicIdPartition(uuid, tp);
        RemoteTopicPartitionDirectory directory = RemoteTopicPartitionDirectory.openTopicPartitionDirectory(idPartition, storageDirectory);
        if (!directory.didExist()) {
            throw new IllegalArgumentException(String.format("Topic-partition directory %s not found", dirname));
        }
        return directory;
    }

    private static String toString(TopicIdPartition topicIdPartition) {
        Uuid uuid = topicIdPartition.topicId();
        TopicPartition tp = topicIdPartition.topicPartition();
        return tp.topic() + "-" + tp.partition() + "-" + uuid.toString();
    }

    static String substr(String filename, int group) {
        Matcher m = FILENAME_FORMAT.matcher(filename);
        if (!m.matches()) {
            throw new IllegalArgumentException(String.format("Not a topic partition directory file: %s", filename));
        }
        return m.group(group);
    }
}

