/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.log.remote.storage;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.server.log.remote.storage.LocalTieredStorage;
import org.apache.kafka.server.log.remote.storage.LocalTieredStorageEvent;
import org.apache.kafka.server.log.remote.storage.LocalTieredStorageListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LocalTieredStorageHistory {
    private static final int HARD_EVENT_COUNT_LIMIT = 1000000;
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalTieredStorageHistory.class);
    private final Map<LocalTieredStorageEvent.EventType, List<LocalTieredStorageEvent>> history = Collections.unmodifiableMap(Arrays.stream(LocalTieredStorageEvent.EventType.values()).collect(Collectors.toMap(Function.identity(), t -> new ArrayList())));

    LocalTieredStorageHistory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LocalTieredStorageEvent> getEvents(LocalTieredStorageEvent.EventType type, TopicPartition topicPartition) {
        List<LocalTieredStorageEvent> matchingTypeEvents;
        List<LocalTieredStorageEvent> list = matchingTypeEvents = this.history.get((Object)type);
        synchronized (list) {
            matchingTypeEvents = new ArrayList<LocalTieredStorageEvent>(matchingTypeEvents);
        }
        return matchingTypeEvents.stream().filter(LocalTieredStorageHistory.matches(topicPartition)).collect(Collectors.toList());
    }

    public Optional<LocalTieredStorageEvent> latestEvent(LocalTieredStorageEvent.EventType type, TopicPartition topicPartition) {
        return this.getEvents(type, topicPartition).stream().max(Comparator.naturalOrder());
    }

    void listenTo(LocalTieredStorage storage) {
        storage.addListener(new InternalListener());
    }

    private static Predicate<LocalTieredStorageEvent> matches(TopicPartition topicPartition) {
        return event -> event.getTopicPartition().equals((Object)topicPartition);
    }

    private final class InternalListener
    implements LocalTieredStorageListener {
        private InternalListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onStorageEvent(LocalTieredStorageEvent event) {
            List events;
            List list = events = (List)LocalTieredStorageHistory.this.history.get((Object)event.getType());
            synchronized (list) {
                if (events.size() >= 1000000) {
                    LOGGER.error("Reached max number of historical event of type {}, dropping event {}", (Object)event.getType(), (Object)event);
                    return;
                }
                events.add(event);
            }
        }
    }
}

