/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.log.remote.metadata.storage;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Optional;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.log.remote.metadata.storage.RemoteLogMetadataCache;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentId;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentMetadata;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentMetadataUpdate;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentState;
import org.apache.kafka.server.log.remote.storage.RemoteResourceNotFoundException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class RemoteLogMetadataCacheTest {
    private final TopicPartition tp0 = new TopicPartition("foo", 0);
    private final TopicIdPartition tpId0 = new TopicIdPartition(Uuid.randomUuid(), this.tp0);
    private final int segmentSize = 0x100000;
    private final int brokerId0 = 0;
    private final int brokerId1 = 1;
    private final Time time = new MockTime(1L);
    private final RemoteLogMetadataCache cache = new RemoteLogMetadataCache();

    @Test
    public void testCacheAddMetadataOnInvalidArgs() {
        this.cache.markInitialized();
        Assertions.assertThrows(NullPointerException.class, () -> this.cache.addCopyInProgressSegment(null));
        for (RemoteLogSegmentState state : RemoteLogSegmentState.values()) {
            if (state == RemoteLogSegmentState.COPY_SEGMENT_STARTED) continue;
            RemoteLogSegmentId segmentId = new RemoteLogSegmentId(this.tpId0, Uuid.randomUuid());
            RemoteLogSegmentMetadata segmentMetadata = new RemoteLogSegmentMetadata(segmentId, 0L, 100L, -1L, 0, this.time.milliseconds(), 0x100000, Collections.singletonMap(0, 0L));
            RemoteLogSegmentMetadata updatedMetadata = segmentMetadata.createWithUpdates(new RemoteLogSegmentMetadataUpdate(segmentId, this.time.milliseconds(), Optional.empty(), state, 1));
            Assertions.assertThrows(IllegalArgumentException.class, () -> this.cache.addCopyInProgressSegment(updatedMetadata));
        }
    }

    @ParameterizedTest(name="isInitialized={0}")
    @ValueSource(booleans={true, false})
    public void testCacheUpdateMetadataOnInvalidArgs(boolean isInitialized) {
        if (isInitialized) {
            this.cache.markInitialized();
        }
        Assertions.assertThrows(NullPointerException.class, () -> this.cache.updateRemoteLogSegmentMetadata(null));
        for (RemoteLogSegmentState state : RemoteLogSegmentState.values()) {
            if (state == RemoteLogSegmentState.COPY_SEGMENT_STARTED) continue;
            RemoteLogSegmentId segmentId = new RemoteLogSegmentId(this.tpId0, Uuid.randomUuid());
            RemoteLogSegmentMetadataUpdate updatedMetadata = new RemoteLogSegmentMetadataUpdate(segmentId, this.time.milliseconds(), Optional.empty(), state, 1);
            try {
                this.cache.updateRemoteLogSegmentMetadata(updatedMetadata);
                if (!isInitialized) continue;
                Assertions.fail((String)"Should throw RemoteResourceNotFoundException when cache is initialized");
            }
            catch (RemoteResourceNotFoundException ex) {
                if (isInitialized) continue;
                Assertions.fail((String)"Should not throw RemoteResourceNotFoundException when cache is not initialized");
            }
        }
    }

    @Test
    public void testDropEventOnInvalidStateTransition() throws RemoteResourceNotFoundException {
        this.cache.markInitialized();
        int leaderEpoch = 5;
        long offset = 10L;
        RemoteLogSegmentId segmentId = new RemoteLogSegmentId(this.tpId0, Uuid.randomUuid());
        RemoteLogSegmentMetadata segmentMetadata = new RemoteLogSegmentMetadata(segmentId, offset, 100L, -1L, 0, this.time.milliseconds(), 0x100000, Collections.singletonMap(leaderEpoch, offset));
        this.cache.addCopyInProgressSegment(segmentMetadata);
        RemoteLogSegmentMetadataUpdate updatedMetadata = new RemoteLogSegmentMetadataUpdate(segmentId, this.time.milliseconds(), Optional.empty(), RemoteLogSegmentState.DELETE_SEGMENT_FINISHED, 1);
        this.updateAndVerifyCacheContents(updatedMetadata, RemoteLogSegmentState.COPY_SEGMENT_STARTED, leaderEpoch);
        updatedMetadata = new RemoteLogSegmentMetadataUpdate(segmentId, this.time.milliseconds(), Optional.empty(), RemoteLogSegmentState.COPY_SEGMENT_FINISHED, 1);
        this.updateAndVerifyCacheContents(updatedMetadata, RemoteLogSegmentState.COPY_SEGMENT_FINISHED, leaderEpoch);
        updatedMetadata = new RemoteLogSegmentMetadataUpdate(segmentId, this.time.milliseconds(), Optional.empty(), RemoteLogSegmentState.DELETE_SEGMENT_FINISHED, 1);
        this.updateAndVerifyCacheContents(updatedMetadata, RemoteLogSegmentState.COPY_SEGMENT_FINISHED, leaderEpoch);
        updatedMetadata = new RemoteLogSegmentMetadataUpdate(segmentId, this.time.milliseconds(), Optional.empty(), RemoteLogSegmentState.COPY_SEGMENT_STARTED, 1);
        this.updateAndVerifyCacheContents(updatedMetadata, RemoteLogSegmentState.COPY_SEGMENT_FINISHED, leaderEpoch);
        updatedMetadata = new RemoteLogSegmentMetadataUpdate(segmentId, this.time.milliseconds(), Optional.empty(), RemoteLogSegmentState.DELETE_SEGMENT_STARTED, 1);
        this.updateAndVerifyCacheContents(updatedMetadata, RemoteLogSegmentState.DELETE_SEGMENT_STARTED, leaderEpoch);
        updatedMetadata = new RemoteLogSegmentMetadataUpdate(segmentId, this.time.milliseconds(), Optional.empty(), RemoteLogSegmentState.COPY_SEGMENT_FINISHED, 1);
        this.updateAndVerifyCacheContents(updatedMetadata, RemoteLogSegmentState.DELETE_SEGMENT_STARTED, leaderEpoch);
        updatedMetadata = new RemoteLogSegmentMetadataUpdate(segmentId, this.time.milliseconds(), Optional.empty(), RemoteLogSegmentState.COPY_SEGMENT_STARTED, 1);
        this.updateAndVerifyCacheContents(updatedMetadata, RemoteLogSegmentState.DELETE_SEGMENT_STARTED, leaderEpoch);
        updatedMetadata = new RemoteLogSegmentMetadataUpdate(segmentId, this.time.milliseconds(), Optional.empty(), RemoteLogSegmentState.DELETE_SEGMENT_FINISHED, 1);
        this.updateAndVerifyCacheContents(updatedMetadata, RemoteLogSegmentState.DELETE_SEGMENT_FINISHED, leaderEpoch);
    }

    private void updateAndVerifyCacheContents(RemoteLogSegmentMetadataUpdate updatedMetadata, RemoteLogSegmentState expectedSegmentState, int leaderEpoch) throws RemoteResourceNotFoundException {
        this.cache.updateRemoteLogSegmentMetadata(updatedMetadata);
        ArrayList metadataList = new ArrayList();
        this.cache.listRemoteLogSegments(leaderEpoch).forEachRemaining(metadataList::add);
        if (expectedSegmentState != RemoteLogSegmentState.DELETE_SEGMENT_FINISHED) {
            Assertions.assertEquals((int)1, (int)metadataList.size());
            Assertions.assertEquals((Object)expectedSegmentState, (Object)((RemoteLogSegmentMetadata)metadataList.get(0)).state());
        } else {
            Assertions.assertTrue((boolean)metadataList.isEmpty());
        }
    }
}

