/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tiered.storage.integration;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import kafka.api.TransactionsTest;
import kafka.log.UnifiedLog;
import kafka.server.HostedPartition;
import kafka.server.KafkaBroker;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.test.TestUtils;
import org.apache.kafka.tiered.storage.utils.BrokerLocalStorage;
import org.apache.kafka.tiered.storage.utils.TieredStorageTestUtils;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import scala.collection.JavaConverters;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.mutable.Buffer;

public class TransactionsWithTieredStoreTest
extends TransactionsTest {
    private String testClassName;
    private String storageDirPath;

    @BeforeEach
    public void setUp(TestInfo testInfo) {
        this.testClassName = ((Class)testInfo.getTestClass().get()).getSimpleName().toLowerCase(Locale.getDefault());
        this.storageDirPath = TestUtils.tempDirectory((String)("kafka-remote-tier-" + this.testClassName)).getAbsolutePath();
        super.setUp(testInfo);
    }

    public Properties overridingProps() {
        Properties props = super.overridingProps();
        int numRemoteLogMetadataPartitions = 3;
        return TieredStorageTestUtils.createPropsForRemoteStorage(this.testClassName, this.storageDirPath, this.brokerCount(), numRemoteLogMetadataPartitions, props);
    }

    public Properties topicConfig() {
        boolean enableRemoteStorage = true;
        int maxBatchCountPerSegment = 1;
        Properties overridingTopicProps = super.topicConfig();
        overridingTopicProps.putAll(TieredStorageTestUtils.createTopicConfigForRemoteStorage(enableRemoteStorage, maxBatchCountPerSegment));
        return overridingTopicProps;
    }

    public void maybeWaitForAtLeastOneSegmentUpload(Seq<TopicPartition> topicPartitions) {
        JavaConverters.seqAsJavaList(topicPartitions).forEach(topicPartition -> {
            List localStorages = JavaConverters.bufferAsJavaList((Buffer)this.brokers()).stream().map(b -> new BrokerLocalStorage(b.config().brokerId(), (String)b.config().logDirs().head(), TieredStorageTestUtils.STORAGE_WAIT_TIMEOUT_SEC)).collect(Collectors.toList());
            localStorages.stream().filter(s -> this.isAssignedReplica((TopicPartition)topicPartition, s.getBrokerId())).filter(s -> this.isAlive(s.getBrokerId())).forEach(localStorage -> localStorage.waitForAtLeastEarliestLocalOffset((TopicPartition)topicPartition, 1L));
        });
    }

    public void maybeVerifyLocalLogStartOffsets(scala.collection.immutable.Map<TopicPartition, Long> partitionLocalStartOffsets) throws InterruptedException {
        HashMap offsets = new HashMap();
        TestUtils.waitForCondition(() -> JavaConverters.seqAsJavaList((Seq)this.brokers()).stream().allMatch(broker -> ((java.util.Map)JavaConverters.mapAsJavaMapConverter((Map)partitionLocalStartOffsets).asJava()).entrySet().stream().allMatch(entry -> {
            long offset = ((UnifiedLog)broker.replicaManager().localLog((TopicPartition)entry.getKey()).get()).localLogStartOffset();
            offsets.put(broker.config().brokerId(), offset);
            return (Long)entry.getValue() == offset;
        })), () -> "local log start offset doesn't change to the expected position:" + partitionLocalStartOffsets + ", current position:" + offsets);
    }

    private boolean isAssignedReplica(TopicPartition topicPartition, Integer replicaId) {
        HostedPartition hostedPartition;
        Optional<KafkaBroker> brokerOpt = JavaConverters.seqAsJavaList((Seq)this.brokers()).stream().filter(b -> b.config().brokerId() == replicaId.intValue()).findFirst();
        boolean isAssigned = false;
        if (brokerOpt.isPresent() && (hostedPartition = brokerOpt.get().replicaManager().getPartition(topicPartition)) instanceof HostedPartition.Online) {
            isAssigned = true;
        }
        return isAssigned;
    }

    private boolean isAlive(Integer brokerId) {
        return this.aliveBrokers().exists(b -> b.config().brokerId() == brokerId.intValue());
    }
}

