/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tiered.storage.actions;

import java.io.PrintStream;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.apache.kafka.server.log.remote.storage.LocalTieredStorage;
import org.apache.kafka.server.log.remote.storage.LocalTieredStorageCondition;
import org.apache.kafka.server.log.remote.storage.LocalTieredStorageEvent;
import org.apache.kafka.tiered.storage.TieredStorageTestAction;
import org.apache.kafka.tiered.storage.TieredStorageTestContext;
import org.apache.kafka.tiered.storage.specs.RemoteDeleteSegmentSpec;

public final class DeleteTopicAction
implements TieredStorageTestAction {
    private static final int DELETE_WAIT_TIMEOUT_SEC = 10;
    private final String topic;
    private final List<RemoteDeleteSegmentSpec> deleteSegmentSpecs;
    private final Boolean shouldDelete;

    public DeleteTopicAction(String topic, List<RemoteDeleteSegmentSpec> deleteSegmentSpecs, Boolean shouldDelete) {
        this.topic = topic;
        this.deleteSegmentSpecs = deleteSegmentSpecs;
        this.shouldDelete = shouldDelete;
    }

    @Override
    public void doExecute(TieredStorageTestContext context) throws ExecutionException, InterruptedException, TimeoutException {
        List<LocalTieredStorage> tieredStorages = context.remoteStorageManagers();
        List tieredStorageConditions = this.deleteSegmentSpecs.stream().filter(spec -> spec.getEventType() == LocalTieredStorageEvent.EventType.DELETE_SEGMENT || spec.getEventType() == LocalTieredStorageEvent.EventType.DELETE_PARTITION).map(spec -> LocalTieredStorageCondition.expectEvent((Iterable<LocalTieredStorage>)tieredStorages, spec.getEventType(), spec.getSourceBrokerId(), spec.getTopicPartition(), false, spec.getEventCount())).collect(Collectors.toList());
        if (this.shouldDelete.booleanValue()) {
            context.deleteTopic(this.topic);
        }
        if (!tieredStorageConditions.isEmpty()) {
            ((LocalTieredStorageCondition)tieredStorageConditions.stream().reduce(LocalTieredStorageCondition::and).get()).waitUntilTrue(10L, TimeUnit.SECONDS);
        }
    }

    @Override
    public void describe(PrintStream output) {
        String action = this.shouldDelete != false ? "delete-topic" : "wait-for-segment-deletion";
        output.println(action + ": " + this.topic);
        this.deleteSegmentSpecs.forEach(spec -> output.println("    " + spec));
    }
}

