/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.log.remote.storage;

import java.util.Objects;
import java.util.Optional;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.server.log.remote.storage.LocalTieredStorageCondition;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentFileset;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentId;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentMetadata;

public final class LocalTieredStorageEvent
implements Comparable<LocalTieredStorageEvent> {
    private final int brokerId;
    private final EventType type;
    private final RemoteLogSegmentId segmentId;
    private final int timestamp;
    private final Optional<RemoteLogSegmentFileset> fileset;
    private final Optional<RemoteLogSegmentMetadata> metadata;
    private final int startPosition;
    private final int endPosition;
    private final Optional<Exception> exception;

    public boolean matches(LocalTieredStorageCondition condition) {
        if (this.brokerId != condition.brokerId) {
            return false;
        }
        if (condition.eventType != this.type) {
            return false;
        }
        if (!this.segmentId.topicIdPartition().topicPartition().equals((Object)condition.topicPartition)) {
            return false;
        }
        if (!this.exception.map(e -> condition.failed).orElseGet(() -> !condition.failed).booleanValue()) {
            return false;
        }
        if (condition.baseOffset != null && !this.metadata.isPresent()) {
            return false;
        }
        return condition.baseOffset == null || this.metadata.get().startOffset() == (long)condition.baseOffset.intValue();
    }

    public boolean isAfter(LocalTieredStorageEvent event) {
        return event.timestamp < this.timestamp;
    }

    public EventType getType() {
        return this.type;
    }

    public TopicPartition getTopicPartition() {
        return this.segmentId.topicIdPartition().topicPartition();
    }

    @Override
    public int compareTo(LocalTieredStorageEvent other) {
        Objects.requireNonNull(other);
        return this.timestamp - other.timestamp;
    }

    public String toString() {
        return String.format("LocalTieredStorageEvent[type=%s brokerId=%s segmentId=%s timestamp=%s exception=%s", new Object[]{this.type, this.brokerId, this.segmentId, this.timestamp, this.exception});
    }

    private LocalTieredStorageEvent(Builder builder) {
        this.brokerId = builder.brokerId;
        this.type = builder.eventType;
        this.segmentId = builder.segmentId;
        this.timestamp = builder.timestamp;
        this.fileset = Optional.ofNullable(builder.fileset);
        this.metadata = Optional.ofNullable(builder.metadata);
        this.startPosition = builder.startPosition;
        this.endPosition = builder.endPosition;
        this.exception = Optional.ofNullable(builder.exception);
    }

    public static Builder newBuilder(int brokerId, EventType type, int time, RemoteLogSegmentId segmentId) {
        return new Builder(brokerId, type, time, segmentId);
    }

    public static class Builder {
        private int brokerId;
        private EventType eventType;
        private RemoteLogSegmentId segmentId;
        private int timestamp;
        private RemoteLogSegmentFileset fileset;
        private RemoteLogSegmentMetadata metadata;
        private int startPosition;
        private int endPosition;
        private Exception exception;

        public Builder withFileset(RemoteLogSegmentFileset fileset) {
            this.fileset = fileset;
            return this;
        }

        public Builder withMetadata(RemoteLogSegmentMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public Builder withStartPosition(int startPosition) {
            this.startPosition = startPosition;
            return this;
        }

        public Builder withEndPosition(int endPosition) {
            this.endPosition = endPosition;
            return this;
        }

        public Builder withException(Exception exception) {
            this.exception = exception;
            return this;
        }

        public LocalTieredStorageEvent build() {
            return new LocalTieredStorageEvent(this);
        }

        private Builder(int brokerId, EventType type, int time, RemoteLogSegmentId segId) {
            this.brokerId = brokerId;
            this.eventType = Objects.requireNonNull(type);
            this.timestamp = time;
            this.segmentId = Objects.requireNonNull(segId);
        }
    }

    public static enum EventType {
        COPY_SEGMENT,
        FETCH_SEGMENT,
        FETCH_OFFSET_INDEX,
        FETCH_TIME_INDEX,
        FETCH_TRANSACTION_INDEX,
        FETCH_LEADER_EPOCH_CHECKPOINT,
        FETCH_PRODUCER_SNAPSHOT,
        DELETE_SEGMENT,
        DELETE_PARTITION;

    }
}

